SELECT /*+ PARALLEL(AUTO) */
  NULL AS CONSTRAINT_CATALOG,
  OWNER AS CONSTRAINT_SCHEMA,
  CONSTRAINT_NAME,
  NULL AS TABLE_CATALOG,
  OWNER AS TABLE_SCHEMA,
  TABLE_NAME,
  CASE CONSTRAINT_TYPE WHEN 'C' THEN 'CHECK' WHEN 'U' THEN 'UNIQUE' WHEN 'P' THEN 'PRIMARY KEY' WHEN 'R' THEN 'FOREIGN KEY' END AS CONSTRAINT_TYPE,
  CASE WHEN DEFERRABLE = 'NOT DEFERRABLE' THEN 'N' ELSE 'Y' END AS IS_DEFERRABLE,
  CASE WHEN DEFERRED = 'IMMEDIATE' THEN 'N' ELSE 'Y' END AS INITIALLY_DEFERRED
FROM
  ALL_CONSTRAINTS
WHERE
  OWNER NOT IN ('CTXSYS', 'DBSNMP', 'DMSYS', 'MDDATA', 'MDSYS', 'OLAPSYS', 'ORDPLUGINS', 'ORDSYS', 'OUTLN', 'SI_INFORMTN_SCHEMA', 'SYS', 'SYSMAN', 'SYSTEM', 'XDB', 'DBSNMP')
  AND OWNER NOT LIKE 'APEX%'
  AND TABLE_NAME NOT LIKE 'BIN$%'
  AND CONSTRAINT_TYPE IN ('C', 'U', 'P', 'R')
