/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import de.pdark.decentxml.BasicNode;
import de.pdark.decentxml.Document;
import de.pdark.decentxml.Element;
import de.pdark.decentxml.Location;
import de.pdark.decentxml.Node;
import de.pdark.decentxml.Token;
import de.pdark.decentxml.XMLSource;

public class XMLParseException
extends RuntimeException {
    private XMLSource source;
    private Token token;
    private Location location;
    private Element element;
    private Document doc;
    private Node node;

    public XMLParseException(String message, XMLSource source, int offset) {
        super(message);
        this.setSource(source, offset);
    }

    public XMLParseException(String message, Token token) {
        this(message);
        this.setToken(token);
    }

    public XMLParseException(String message) {
        super(message);
    }

    public XMLParseException(String message, Throwable cause) {
        super(message, cause);
    }

    public XMLParseException(String message, Document doc, Node node) {
        super(message);
        this.setNode(doc, node);
    }

    public void setNode(Document doc, Node node) {
        this.doc = doc;
        this.node = node;
        if (doc != null && node != null) {
            this.location = new Location(doc, node);
        }
    }

    public XMLParseException(String message, Node node) {
        super(message);
        if (node instanceof Element) {
            this.setElement((Element)node);
        } else if (node instanceof BasicNode) {
            BasicNode n = (BasicNode)node;
            this.setToken(n.getToken());
        }
    }

    public XMLParseException(String message, Element e) {
        super(message);
        this.setElement(e);
    }

    public XMLParseException setElement(Element e) {
        this.element = e;
        if (e != null) {
            this.location = new Location(e);
        }
        return this;
    }

    public XMLParseException setSource(XMLSource source, int offset) {
        this.source = source;
        if (source != null) {
            this.location = new Location(source, offset);
        }
        return this;
    }

    public XMLParseException setToken(Token token) {
        this.token = token;
        if (token != null) {
            this.setSource(token.getSource(), token.getStartOffset());
        }
        return this;
    }

    public XMLSource getSource() {
        return this.source;
    }

    public Token getToken() {
        return this.token;
    }

    public Element getElement() {
        return this.element;
    }

    public Document getDoc() {
        if (this.doc == null) {
            return this.element == null ? null : this.element.getDocument();
        }
        return this.doc;
    }

    public Node getNode() {
        return this.node;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getLine() {
        return this.location == null ? -1 : this.location.getLine();
    }

    public int getColumn() {
        return this.location == null ? -1 : this.location.getColumn();
    }

    public int getOffset() {
        return this.location == null ? -1 : this.location.getOffset();
    }

    public int getLineStartOffset() {
        return this.location == null ? -1 : this.location.getLineStartOffset();
    }

    public String getMessage() {
        if (this.location == null) {
            return super.getMessage();
        }
        return "Line " + this.getLine() + ", column " + this.getColumn() + ": " + super.getMessage();
    }

    public String getMessageWithoutLocation() {
        return super.getMessage();
    }
}

