/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.report.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListenerException;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.Rule;
import java.util.Map;
import java.util.TreeMap;

public class InMemoryReportWriter
implements AnalysisListener<AnalysisListenerException> {
    private AnalysisListener<AnalysisListenerException> delegate;
    private Map<String, Result<Concept>> conceptResults = new TreeMap<String, Result<Concept>>();
    private Map<String, Result<Constraint>> constraintResults = new TreeMap<String, Result<Constraint>>();
    private Result<? extends Rule> currentResult;

    public InMemoryReportWriter(AnalysisListener<AnalysisListenerException> delegate) {
        this.delegate = delegate;
    }

    public void begin() throws AnalysisListenerException {
        this.delegate.begin();
    }

    public void end() throws AnalysisListenerException {
        this.delegate.end();
    }

    public void beginConcept(Concept concept) throws AnalysisListenerException {
        this.delegate.beginConcept(concept);
    }

    public void endConcept() throws AnalysisListenerException {
        this.addResult(this.conceptResults);
        this.delegate.endConcept();
    }

    public void beginGroup(Group group) throws AnalysisListenerException {
        this.delegate.beginGroup(group);
    }

    public void endGroup() throws AnalysisListenerException {
        this.delegate.endGroup();
    }

    public void beginConstraint(Constraint constraint) throws AnalysisListenerException {
        this.delegate.beginConstraint(constraint);
    }

    public void endConstraint() throws AnalysisListenerException {
        this.addResult(this.constraintResults);
        this.delegate.endConstraint();
    }

    public void setResult(Result<? extends ExecutableRule> result) throws AnalysisListenerException {
        this.currentResult = result;
        this.delegate.setResult(result);
    }

    public Map<String, Result<Concept>> getConceptResults() {
        return this.conceptResults;
    }

    public Map<String, Result<Constraint>> getConstraintResults() {
        return this.constraintResults;
    }

    private <T extends ExecutableRule> void addResult(Map<String, Result<T>> results) {
        if (this.currentResult != null) {
            results.put(this.currentResult.getRule().getId(), this.currentResult);
            this.currentResult = null;
        }
    }
}

