/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.report.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListenerException;
import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class CompositeReportWriter
implements AnalysisListener<AnalysisListenerException> {
    private Map<String, AnalysisListener> reportWriters;
    private Iterable<AnalysisListener> selectedReportWriters = Collections.emptyList();

    public CompositeReportWriter(Map<String, AnalysisListener> reportWriters) {
        this.reportWriters = reportWriters;
        this.selectedReportWriters = reportWriters.values();
    }

    public void begin() throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.begin();
            }
        });
    }

    public void end() throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.end();
            }
        });
    }

    public void beginConcept(final Concept concept) throws AnalysisListenerException {
        this.selectReportWriter((ExecutableRule)concept);
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.beginConcept(concept);
            }
        });
    }

    public void endConcept() throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.endConcept();
            }
        });
        this.resetReportWriter();
    }

    public void beginGroup(final Group group) throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.beginGroup(group);
            }
        });
    }

    public void endGroup() throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.endGroup();
            }
        });
    }

    public void beginConstraint(final Constraint constraint) throws AnalysisListenerException {
        this.selectReportWriter((ExecutableRule)constraint);
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.beginConstraint(constraint);
            }
        });
    }

    public void endConstraint() throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.endConstraint();
            }
        });
        this.resetReportWriter();
    }

    public void setResult(final Result<? extends ExecutableRule> result) throws AnalysisListenerException {
        this.run(new DelegateOperation(){

            @Override
            public void run(AnalysisListener reportWriter) throws AnalysisListenerException {
                reportWriter.setResult(result);
            }
        });
    }

    private void run(DelegateOperation operation) throws AnalysisListenerException {
        for (AnalysisListener reportWriter : this.selectedReportWriters) {
            operation.run(reportWriter);
        }
    }

    private void selectReportWriter(ExecutableRule rule) throws AnalysisListenerException {
        Set selection = rule.getReport().getSelectedTypes();
        if (selection == null) {
            this.selectedReportWriters = this.reportWriters.values();
        } else {
            ArrayList<AnalysisListener> selectedReportWriters = new ArrayList<AnalysisListener>();
            for (String type : selection) {
                AnalysisListener analysisListener = this.reportWriters.get(type);
                if (analysisListener == null) {
                    throw new AnalysisListenerException("Unknown report selection '" + type + "' selected for '" + rule + "'");
                }
                selectedReportWriters.add(analysisListener);
            }
            this.selectedReportWriters = selectedReportWriters;
        }
    }

    private void resetReportWriter() {
        this.selectedReportWriters = this.reportWriters.values();
    }

    private static interface DelegateOperation {
        public void run(AnalysisListener var1) throws AnalysisListenerException;
    }
}

