/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.report.api;

import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Rule;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.report.api.LanguageElement;
import com.buschmais.jqassistant.core.report.api.LanguageHelper;
import com.buschmais.jqassistant.core.report.api.SourceProvider;
import com.buschmais.jqassistant.core.report.impl.InMemoryReportWriter;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.slf4j.Logger;

public final class ReportHelper {
    public static String CONSTRAINT_VIOLATION_HEADER = "--[ Constraint Violation ]-----------------------------------------";
    public static String CONCEPT_FAILED_HEADER = "--[ Concept Application Failure ]----------------------------------";
    private static String FOOTER = "-------------------------------------------------------------------";
    private Logger logger;

    public ReportHelper(Logger log) {
        this.logger = log;
    }

    public int verifyConceptResults(Severity violationSeverity, InMemoryReportWriter inMemoryReportWriter) {
        Collection<Result<Concept>> conceptResults = inMemoryReportWriter.getConceptResults().values();
        return this.verifyRuleResults(conceptResults, violationSeverity, "Concept", CONCEPT_FAILED_HEADER, false);
    }

    public int verifyConstraintResults(Severity violationSeverity, InMemoryReportWriter inMemoryReportWriter) {
        Collection<Result<Constraint>> constraintResults = inMemoryReportWriter.getConstraintResults().values();
        return this.verifyRuleResults(constraintResults, violationSeverity, "Constraint", CONSTRAINT_VIOLATION_HEADER, true);
    }

    private int verifyRuleResults(Collection<? extends Result<? extends ExecutableRule>> results, Severity violationSeverity, String type, String header, boolean logResult) {
        int violations = 0;
        for (Result<? extends ExecutableRule> result : results) {
            if (!Result.Status.FAILURE.equals((Object)result.getStatus())) continue;
            ExecutableRule rule = result.getRule();
            String severityInfo = rule.getSeverity().getInfo(result.getSeverity());
            List<String> resultRows = this.getResultRows(result, logResult);
            if (result.getSeverity().getLevel() <= violationSeverity.getLevel()) {
                ++violations;
                this.logger.error(header);
                this.logger.error(type + ": " + rule.getId());
                this.logger.error("Severity: " + severityInfo);
                this.logDescription((Rule)rule);
                for (String row : resultRows) {
                    this.logger.error(row);
                }
                this.logger.error(FOOTER);
                this.logger.error(System.lineSeparator());
                continue;
            }
            this.logger.warn(type + " failed: " + rule.getId() + ", Severity: " + severityInfo);
            for (String row : resultRows) {
                this.logger.debug(row);
            }
        }
        return violations;
    }

    private List<String> getResultRows(Result<?> result, boolean logResult) {
        ArrayList<String> rows = new ArrayList<String>();
        if (logResult) {
            for (Map columns : result.getRows()) {
                StringBuilder row = new StringBuilder();
                for (Map.Entry entry : columns.entrySet()) {
                    if (row.length() > 0) {
                        row.append(", ");
                    }
                    row.append((String)entry.getKey());
                    row.append('=');
                    String stringValue = ReportHelper.getLabel(entry.getValue());
                    row.append(stringValue);
                }
                rows.add("  " + row.toString());
            }
        }
        return rows;
    }

    private void logDescription(Rule rule) {
        String description = rule.getDescription();
        StringTokenizer tokenizer = new StringTokenizer(description, "\n");
        while (tokenizer.hasMoreTokens()) {
            this.logger.error(tokenizer.nextToken().replaceAll("(\\r|\\n|\\t)", ""));
        }
    }

    public static String getLabel(Object value) {
        if (value != null) {
            if (value instanceof Descriptor) {
                Descriptor descriptor = (Descriptor)value;
                String label = ReportHelper.getLanguageLabel(descriptor);
                return label != null ? label : descriptor.toString();
            }
            if (value.getClass().isArray()) {
                Object[] objects = (Object[])value;
                return ReportHelper.getLabel(Arrays.asList(objects));
            }
            if (value instanceof Iterable) {
                StringBuilder sb = new StringBuilder();
                for (Object o : (Iterable)value) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append(ReportHelper.getLabel(o));
                }
                return "[" + sb.toString() + "]";
            }
            if (value instanceof Map) {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    if (sb.length() > 0) {
                        sb.append(",");
                    }
                    sb.append((String)entry.getKey());
                    sb.append(":");
                    sb.append(ReportHelper.getLabel(entry.getValue()));
                }
                return "{" + sb.toString() + "}";
            }
            return value.toString();
        }
        return null;
    }

    private static String getLanguageLabel(Descriptor descriptor) {
        LanguageElement elementValue = LanguageHelper.getLanguageElement(descriptor);
        if (elementValue != null) {
            SourceProvider<Descriptor> sourceProvider = elementValue.getSourceProvider();
            return sourceProvider.getName(descriptor);
        }
        return null;
    }
}

