/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import java.awt.Font;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.Util;
import org.rrd4j.data.Plottable;
import org.rrd4j.graph.Area;
import org.rrd4j.graph.CDef;
import org.rrd4j.graph.CommentText;
import org.rrd4j.graph.Def;
import org.rrd4j.graph.HRule;
import org.rrd4j.graph.HSpan;
import org.rrd4j.graph.LegendText;
import org.rrd4j.graph.Line;
import org.rrd4j.graph.PDef;
import org.rrd4j.graph.PercentileDef;
import org.rrd4j.graph.PlotElement;
import org.rrd4j.graph.PrintText;
import org.rrd4j.graph.RrdGraphConstants;
import org.rrd4j.graph.SDef;
import org.rrd4j.graph.Source;
import org.rrd4j.graph.SourcedPlotElement;
import org.rrd4j.graph.Stack;
import org.rrd4j.graph.TDef;
import org.rrd4j.graph.TimeAxisSetting;
import org.rrd4j.graph.VRule;
import org.rrd4j.graph.VSpan;
import org.rrd4j.graph.ValueAxisSetting;

public class RrdGraphDef
implements RrdGraphConstants {
    boolean poolUsed = false;
    boolean antiAliasing = false;
    boolean textAntiAliasing = false;
    String filename = "-";
    long startTime;
    long endTime;
    TimeAxisSetting timeAxisSetting = null;
    ValueAxisSetting valueAxisSetting = null;
    boolean altYGrid = false;
    boolean noMinorGrid = false;
    boolean altYMrtg = false;
    boolean altAutoscale = false;
    boolean altAutoscaleMax = false;
    int unitsExponent = Integer.MAX_VALUE;
    int unitsLength = 9;
    String verticalLabel = null;
    int width = 400;
    int height = 100;
    boolean interlaced = false;
    String imageInfo = null;
    String imageFormat = "gif";
    float imageQuality = 0.8f;
    String backgroundImage = null;
    String overlayImage = null;
    String unit = null;
    boolean lazy = false;
    double minValue = Double.NaN;
    double maxValue = Double.NaN;
    boolean rigid = false;
    double base = 1000.0;
    boolean logarithmic = false;
    Paint[] colors = new Paint[]{DEFAULT_CANVAS_COLOR, DEFAULT_BACK_COLOR, DEFAULT_SHADEA_COLOR, DEFAULT_SHADEB_COLOR, DEFAULT_GRID_COLOR, DEFAULT_MGRID_COLOR, DEFAULT_FONT_COLOR, DEFAULT_FRAME_COLOR, DEFAULT_ARROW_COLOR, DEFAULT_XAXIS_COLOR};
    boolean noLegend = false;
    boolean onlyGraph = false;
    boolean forceRulesLegend = false;
    String title = null;
    long step = 0L;
    Font smallFont = RrdGraphConstants.DEFAULT_SMALL_FONT;
    Font largeFont = RrdGraphConstants.DEFAULT_LARGE_FONT;
    boolean drawXGrid = true;
    boolean drawYGrid = true;
    int firstDayOfWeek = FIRST_DAY_OF_WEEK;
    Locale locale = Locale.getDefault();
    TimeZone tz = TimeZone.getDefault();
    boolean showSignature = true;
    Stroke gridStroke = GRID_STROKE;
    Stroke tickStroke = TICK_STROKE;
    final List<Source> sources = new ArrayList<Source>();
    final List<CommentText> comments = new ArrayList<CommentText>();
    final List<PlotElement> plotElements = new ArrayList<PlotElement>();

    public RrdGraphDef() {
        this.setTimeSpan(Util.getTimestamps("end-1d", "now"));
    }

    public void setStartTime(long time) {
        this.startTime = time;
        if (time <= 0L) {
            this.startTime += Util.getTime();
        }
    }

    public void setEndTime(long time) {
        this.endTime = time;
        if (time <= 0L) {
            this.endTime += Util.getTime();
        }
    }

    public void setTimeSpan(long startTime, long endTime) {
        this.setStartTime(startTime);
        this.setEndTime(endTime);
    }

    public void setTimeSpan(long[] timestamps) {
        this.setTimeSpan(timestamps[0], timestamps[timestamps.length - 1]);
    }

    public void setPoolUsed(boolean poolUsed) {
        this.poolUsed = poolUsed;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void setTimeAxis(int minorUnit, int minorUnitCount, int majorUnit, int majorUnitCount, int labelUnit, int labelUnitCount, int labelSpan, String simpleDateFormat) {
        this.timeAxisSetting = new TimeAxisSetting(minorUnit, minorUnitCount, majorUnit, majorUnitCount, labelUnit, labelUnitCount, labelSpan, simpleDateFormat);
    }

    public void setValueAxis(double gridStep, int labelFactor) {
        this.valueAxisSetting = new ValueAxisSetting(gridStep, labelFactor);
    }

    public void setAltYGrid(boolean altYGrid) {
        this.altYGrid = altYGrid;
    }

    public void setNoMinorGrid(boolean noMinorGrid) {
        this.noMinorGrid = noMinorGrid;
    }

    public void setAltYMrtg(boolean altYMrtg) {
        this.altYMrtg = altYMrtg;
    }

    public void setAltAutoscale(boolean altAutoscale) {
        this.altAutoscale = altAutoscale;
    }

    public void setAltAutoscaleMax(boolean altAutoscaleMax) {
        this.altAutoscaleMax = altAutoscaleMax;
    }

    public void setUnitsExponent(int unitsExponent) {
        this.unitsExponent = unitsExponent;
    }

    public void setUnitsLength(int unitsLength) {
        this.unitsLength = unitsLength;
    }

    public void setVerticalLabel(String verticalLabel) {
        this.verticalLabel = verticalLabel;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setInterlaced(boolean interlaced) {
        this.interlaced = interlaced;
    }

    public void setImageInfo(String imageInfo) {
        this.imageInfo = imageInfo;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = backgroundImage;
    }

    public void setOverlayImage(String overlayImage) {
        this.overlayImage = overlayImage;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setLazy(boolean lazy) {
        this.lazy = lazy;
    }

    public void setMinValue(double minValue) {
        this.minValue = minValue;
    }

    public void setMaxValue(double maxValue) {
        this.maxValue = maxValue;
    }

    public void setRigid(boolean rigid) {
        this.rigid = rigid;
    }

    public void setBase(double base) {
        this.base = base;
    }

    public void setLogarithmic(boolean logarithmic) {
        this.logarithmic = logarithmic;
    }

    public void setColor(int colorTag, Paint color) {
        if (colorTag < 0 || colorTag >= this.colors.length) {
            throw new IllegalArgumentException("Invalid color index specified: " + colorTag);
        }
        this.colors[colorTag] = color;
    }

    public void setColor(String colorName, Paint color) {
        this.setColor(RrdGraphDef.getColorTagByName(colorName), color);
    }

    private static int getColorTagByName(String colorName) {
        for (int i = 0; i < COLOR_NAMES.length; ++i) {
            if (!COLOR_NAMES[i].equalsIgnoreCase(colorName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown color name specified: " + colorName);
    }

    public void setNoLegend(boolean noLegend) {
        this.noLegend = noLegend;
    }

    public void setOnlyGraph(boolean onlyGraph) {
        this.onlyGraph = onlyGraph;
    }

    public void setForceRulesLegend(boolean forceRulesLegend) {
        this.forceRulesLegend = forceRulesLegend;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setStep(long step) {
        this.step = step;
    }

    public void setSmallFont(Font smallFont) {
        this.smallFont = smallFont;
    }

    public void setLargeFont(Font largeFont) {
        this.largeFont = largeFont;
    }

    public void datasource(String name, String rrdPath, String dsName, ConsolFun consolFun) {
        this.sources.add(new Def(name, rrdPath, dsName, consolFun));
    }

    public void datasource(String name, String rrdPath, String dsName, ConsolFun consolFun, String backend) {
        this.sources.add(new Def(name, rrdPath, dsName, consolFun, backend));
    }

    public void datasource(String name, String rpnExpression) {
        this.sources.add(new CDef(name, rpnExpression));
    }

    public void datasource(String name, String defName, ConsolFun consolFun) {
        this.sources.add(new SDef(name, defName, consolFun));
    }

    public void datasource(String name, Plottable plottable) {
        this.sources.add(new PDef(name, plottable));
    }

    public void datasource(String name, FetchData fetchData) {
        this.sources.add(new TDef(name, fetchData));
    }

    public void percentile(String name, String defName) {
        this.percentile(name, defName, 95.0);
    }

    public void percentile(String name, String defName, double percent) {
        this.sources.add(new PercentileDef(name, defName, percent));
    }

    public void print(String srcName, ConsolFun consolFun, String format) {
        this.comments.add(new PrintText(srcName, consolFun, format, false));
    }

    public void gprint(String srcName, ConsolFun consolFun, String format) {
        this.comments.add(new PrintText(srcName, consolFun, format, true));
    }

    public void comment(String text) {
        this.comments.add(new CommentText(text));
    }

    public void hrule(double value, Paint color) {
        this.hrule(value, color, null, 1.0f);
    }

    public void hrule(double value, Paint color, String legend) {
        this.hrule(value, color, legend, 1.0f);
    }

    public void hrule(double value, Paint color, String legend, float width) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new HRule(value, color, legendText, width));
    }

    public void vrule(long timestamp, Paint color) {
        this.vrule(timestamp, color, null, 1.0f);
    }

    public void vrule(long timestamp, Paint color, String legend) {
        this.vrule(timestamp, color, legend, 1.0f);
    }

    public void vrule(long timestamp, Paint color, String legend, float width) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new VRule(timestamp, color, legendText, width));
    }

    public void hspan(double start, double end, Paint color) {
        this.hspan(start, end, color, null);
    }

    public void hspan(double start, double end, Paint color, String legend) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new HSpan(start, end, color, legendText));
    }

    public void vspan(long start, long end, Paint color) {
        this.vspan(start, end, color, null);
    }

    public void vspan(long start, long end, Paint color, String legend) {
        LegendText legendText = new LegendText(color, legend);
        this.comments.add(legendText);
        this.plotElements.add(new VSpan(start, end, color, legendText));
    }

    public void line(String srcName, Paint color) {
        this.line(srcName, color, null, 1.0f);
    }

    public void line(String srcName, Paint color, String legend) {
        this.line(srcName, color, legend, 1.0f);
    }

    public void line(String srcName, Paint color, float width) {
        this.line(srcName, color, null, width);
    }

    public void line(String srcName, Paint color, String legend, float width) {
        if (legend != null) {
            this.comments.add(new LegendText(color, legend));
        }
        this.plotElements.add(new Line(srcName, color, width));
    }

    public void area(String srcName, Paint color) {
        this.area(srcName, color, null);
    }

    public void area(String srcName, Paint color, String legend) {
        if (legend != null) {
            this.comments.add(new LegendText(color, legend));
        }
        this.plotElements.add(new Area(srcName, color));
    }

    public void stack(String srcName, Paint color) {
        this.stack(srcName, color, null);
    }

    public void stack(String srcName, Paint color, String legend) {
        SourcedPlotElement parent = null;
        for (int i = this.plotElements.size() - 1; i >= 0; --i) {
            PlotElement plotElement = this.plotElements.get(i);
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            parent = (SourcedPlotElement)plotElement;
            break;
        }
        if (parent == null) {
            throw new IllegalArgumentException("You have to stack graph onto something (line or area)");
        }
        if (legend != null) {
            this.comments.add(new LegendText(color, legend));
        }
        this.plotElements.add(new Stack(parent, srcName, color));
    }

    public void setDrawXGrid(boolean drawXGrid) {
        this.drawXGrid = drawXGrid;
    }

    public void setDrawYGrid(boolean drawYGrid) {
        this.drawYGrid = drawYGrid;
    }

    public void setImageQuality(float imageQuality) {
        this.imageQuality = imageQuality;
    }

    public void setAntiAliasing(boolean antiAliasing) {
        this.antiAliasing = antiAliasing;
    }

    public void setTextAntiAliasing(boolean textAntiAliasing) {
        this.textAntiAliasing = textAntiAliasing;
    }

    public void setShowSignature(boolean showSignature) {
        this.showSignature = showSignature;
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        this.firstDayOfWeek = firstDayOfWeek;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.firstDayOfWeek = Calendar.getInstance(Locale.getDefault()).getFirstDayOfWeek();
    }

    public void setTimeZone(TimeZone tz) {
        this.tz = tz;
    }

    public void setGridStroke(Stroke gridStroke) {
        this.gridStroke = gridStroke;
    }

    public void setTickStroke(Stroke tickStroke) {
        this.tickStroke = tickStroke;
    }

    int printStatementCount() {
        int count = 0;
        for (CommentText comment : this.comments) {
            if (!(comment instanceof PrintText) || !comment.isPrint()) continue;
            ++count;
        }
        return count;
    }

    boolean shouldPlot() {
        if (this.plotElements.size() > 0) {
            return true;
        }
        for (CommentText comment : this.comments) {
            if (!comment.isValidGraphElement()) continue;
            return true;
        }
        return false;
    }
}

