/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.demo;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdToolkit;

public class HeartbeatFix {
    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("SYNTAX: HeartbeatFix <rrd directory> <heartbeat>");
            System.exit(-1);
        }
        File directory = new File(args[0]);
        long heartbeat = Long.parseLong(args[1]);
        File[] files = directory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isFile() && pathname.getName().endsWith(".rrd.jrb");
            }
        });
        System.out.println(files.length + " files found");
        for (int i = 0; i < files.length; ++i) {
            String path = files[i].getAbsolutePath();
            System.out.print(i + 1 + ": " + path + ": ");
            RrdToolkit.setDsHeartbeat(files[i].getAbsolutePath(), 0, heartbeat);
            RrdToolkit.setDsHeartbeat(files[i].getAbsolutePath(), 1, heartbeat);
            System.out.print("fixed");
            RrdDb rrd = new RrdDb(path);
            if (rrd.getRrdDef().getEstimatedSize() == files[i].length() && rrd.getDatasource(0).getHeartbeat() == heartbeat && rrd.getDatasource(1).getHeartbeat() == heartbeat) {
                System.out.println(", verified");
            } else {
                System.out.println(", ********** ERROR **********");
            }
            rrd.close();
        }
        System.out.println("FINISHED!");
    }
}

