/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.io.IOException;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdMongoDBBackend;

public class RrdMongoDBBackendFactory
extends RrdBackendFactory {
    private final DBCollection rrdCollection;

    public RrdMongoDBBackendFactory(DBCollection rrdCollection) {
        this.rrdCollection = rrdCollection;
        rrdCollection.ensureIndex((DBObject)new BasicDBObject("path", (Object)1));
        RrdBackendFactory.registerAndSetAsDefaultFactory(this);
    }

    @Override
    protected RrdBackend open(String path, boolean readOnly) throws IOException {
        return new RrdMongoDBBackend(path, this.rrdCollection);
    }

    @Override
    protected boolean exists(String path) throws IOException {
        BasicDBObject query = new BasicDBObject();
        query.put("path", (Object)path);
        return this.rrdCollection.findOne((DBObject)query) != null;
    }

    @Override
    protected boolean shouldValidateHeader(String path) throws IOException {
        return false;
    }

    @Override
    public String getName() {
        return "MONGODB";
    }
}

