/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.Archive;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.Datasource;
import org.rrd4j.core.DsDef;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.Header;
import org.rrd4j.core.RrdAllocator;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdFileBackend;
import org.rrd4j.core.RrdToolReader;
import org.rrd4j.core.RrdUpdater;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlReader;
import org.rrd4j.core.XmlWriter;

public class RrdDb
implements RrdUpdater {
    public static final String PREFIX_XML = "xml:/";
    public static final String PREFIX_RRDTool = "rrdtool:/";
    static final int XML_BUFFER_CAPACITY = 100000;
    private RrdBackend backend;
    private RrdAllocator allocator = new RrdAllocator();
    private final Header header;
    private final Datasource[] datasources;
    private final Archive[] archives;
    private boolean closed = false;

    public RrdDb(RrdDef rrdDef) throws IOException {
        this(rrdDef, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(RrdDef rrdDef, RrdBackendFactory factory) throws IOException {
        if (!rrdDef.hasDatasources()) {
            throw new IllegalArgumentException("No RRD datasource specified. At least one is needed.");
        }
        if (!rrdDef.hasArchives()) {
            throw new IllegalArgumentException("No RRD archive specified. At least one is needed.");
        }
        String path = rrdDef.getPath();
        this.backend = factory.open(path, false);
        try {
            this.backend.setLength(rrdDef.getEstimatedSize());
            this.header = new Header(this, rrdDef);
            DsDef[] dsDefs = rrdDef.getDsDefs();
            this.datasources = new Datasource[dsDefs.length];
            for (int i = 0; i < dsDefs.length; ++i) {
                this.datasources[i] = new Datasource(this, dsDefs[i]);
            }
            ArcDef[] arcDefs = rrdDef.getArcDefs();
            this.archives = new Archive[arcDefs.length];
            for (int i = 0; i < arcDefs.length; ++i) {
                this.archives[i] = new Archive(this, arcDefs[i]);
            }
        }
        catch (IOException e) {
            this.backend.close();
            throw e;
        }
    }

    public RrdDb(String path, boolean readOnly) throws IOException {
        this(path, readOnly, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(String path, boolean readOnly, RrdBackendFactory factory) throws IOException {
        if (!factory.exists(path)) {
            throw new FileNotFoundException("Could not open " + path + " [non existent]");
        }
        this.backend = factory.open(path, readOnly);
        try {
            this.header = new Header(this, (RrdDef)null);
            if (factory.shouldValidateHeader(path)) {
                this.header.validateHeader();
            }
            int dsCount = this.header.getDsCount();
            this.datasources = new Datasource[dsCount];
            for (int i = 0; i < dsCount; ++i) {
                this.datasources[i] = new Datasource(this, null);
            }
            int arcCount = this.header.getArcCount();
            this.archives = new Archive[arcCount];
            for (int i = 0; i < arcCount; ++i) {
                this.archives[i] = new Archive(this, null);
            }
        }
        catch (IOException e) {
            this.backend.close();
            throw e;
        }
    }

    public RrdDb(String path) throws IOException {
        this(path, false);
    }

    public RrdDb(String path, RrdBackendFactory factory) throws IOException {
        this(path, false, factory);
    }

    public RrdDb(String rrdPath, String externalPath) throws IOException {
        this(rrdPath, externalPath, RrdBackendFactory.getDefaultFactory());
    }

    public RrdDb(String rrdPath, String externalPath, RrdBackendFactory factory) throws IOException {
        DataImporter reader;
        if (externalPath.startsWith(PREFIX_RRDTool)) {
            String rrdToolPath = externalPath.substring(PREFIX_RRDTool.length());
            reader = new RrdToolReader(rrdToolPath);
        } else if (externalPath.startsWith(PREFIX_XML)) {
            externalPath = externalPath.substring(PREFIX_XML.length());
            reader = new XmlReader(externalPath);
        } else {
            reader = new XmlReader(externalPath);
        }
        this.backend = factory.open(rrdPath, false);
        try {
            int i;
            this.backend.setLength(reader.getEstimatedSize());
            this.header = new Header(this, reader);
            this.datasources = new Datasource[reader.getDsCount()];
            for (i = 0; i < this.datasources.length; ++i) {
                this.datasources[i] = new Datasource(this, reader, i);
            }
            this.archives = new Archive[reader.getArcCount()];
            for (i = 0; i < this.archives.length; ++i) {
                this.archives[i] = new Archive(this, reader, i);
            }
            reader.release();
            reader = null;
        }
        catch (IOException e) {
            this.backend.close();
            throw e;
        }
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            this.backend.close();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Header getHeader() {
        return this.header;
    }

    public Datasource getDatasource(int dsIndex) {
        return this.datasources[dsIndex];
    }

    public Archive getArchive(int arcIndex) {
        return this.archives[arcIndex];
    }

    public String[] getDsNames() throws IOException {
        int n = this.datasources.length;
        String[] dsNames = new String[n];
        for (int i = 0; i < n; ++i) {
            dsNames[i] = this.datasources[i].getName();
        }
        return dsNames;
    }

    public Sample createSample(long time) throws IOException {
        return new Sample(this, time);
    }

    public Sample createSample() throws IOException {
        return this.createSample(Util.getTime());
    }

    public FetchRequest createFetchRequest(ConsolFun consolFun, long fetchStart, long fetchEnd, long resolution) {
        return new FetchRequest(this, consolFun, fetchStart, fetchEnd, resolution);
    }

    public FetchRequest createFetchRequest(ConsolFun consolFun, long fetchStart, long fetchEnd) {
        return this.createFetchRequest(consolFun, fetchStart, fetchEnd, 1L);
    }

    final synchronized void store(Sample sample) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("RRD already closed, cannot store this sample");
        }
        long newTime = sample.getTime();
        long lastTime = this.header.getLastUpdateTime();
        if (lastTime >= newTime) {
            throw new IllegalArgumentException("Bad sample time: " + newTime + ". Last update time was " + lastTime + ", at least one second step is required");
        }
        double[] newValues = sample.getValues();
        for (int i = 0; i < this.datasources.length; ++i) {
            double newValue = newValues[i];
            this.datasources[i].process(newTime, newValue);
        }
        this.header.setLastUpdateTime(newTime);
    }

    synchronized FetchData fetchData(FetchRequest request) throws IOException {
        if (this.closed) {
            throw new IllegalStateException("RRD already closed, cannot fetch data");
        }
        Archive archive = this.findMatchingArchive(request);
        return archive.fetchData(request);
    }

    public Archive findMatchingArchive(FetchRequest request) throws IOException {
        ConsolFun consolFun = request.getConsolFun();
        long fetchStart = request.getFetchStart();
        long fetchEnd = request.getFetchEnd();
        long resolution = request.getResolution();
        Archive bestFullMatch = null;
        Archive bestPartialMatch = null;
        long bestStepDiff = 0L;
        long bestMatch = 0L;
        for (Archive archive : this.archives) {
            if (archive.getConsolFun() != consolFun) continue;
            long arcStep = archive.getArcStep();
            long arcStart = archive.getStartTime() - arcStep;
            long arcEnd = archive.getEndTime();
            long fullMatch = fetchEnd - fetchStart;
            if (arcEnd >= fetchEnd && arcStart <= fetchStart) {
                long tmpStepDiff = Math.abs(archive.getArcStep() - resolution);
                if (tmpStepDiff >= bestStepDiff && bestFullMatch != null) continue;
                bestStepDiff = tmpStepDiff;
                bestFullMatch = archive;
                continue;
            }
            long tmpMatch = fullMatch;
            if (arcStart > fetchStart) {
                tmpMatch -= arcStart - fetchStart;
            }
            if (arcEnd < fetchEnd) {
                tmpMatch -= fetchEnd - arcEnd;
            }
            if (bestPartialMatch != null && bestMatch >= tmpMatch) continue;
            bestPartialMatch = archive;
            bestMatch = tmpMatch;
        }
        if (bestFullMatch != null) {
            return bestFullMatch;
        }
        if (bestPartialMatch != null) {
            return bestPartialMatch;
        }
        throw new IllegalStateException("RRD file does not contain RRA: " + (Object)((Object)consolFun) + " archive");
    }

    public Archive findStartMatchArchive(String consolFun, long startTime, long resolution) throws IOException {
        int fallBackIndex = 0;
        int arcIndex = -1;
        long minDiff = Long.MAX_VALUE;
        long fallBackDiff = Long.MAX_VALUE;
        for (int i = 0; i < this.archives.length; ++i) {
            if (!this.archives[i].getConsolFun().toString().equals(consolFun)) continue;
            long arcStep = this.archives[i].getArcStep();
            long diff = Math.abs(resolution - arcStep);
            if (startTime >= this.archives[i].getStartTime()) {
                if (diff == 0L) {
                    return this.archives[i];
                }
                if (diff >= minDiff) continue;
                minDiff = diff;
                arcIndex = i;
                continue;
            }
            if (diff >= fallBackDiff) continue;
            fallBackDiff = diff;
            fallBackIndex = i;
        }
        return arcIndex >= 0 ? this.archives[arcIndex] : this.archives[fallBackIndex];
    }

    public synchronized String dump() throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.header.dump());
        for (Datasource datasource : this.datasources) {
            buffer.append(datasource.dump());
        }
        for (RrdUpdater rrdUpdater : this.archives) {
            buffer.append(((Archive)rrdUpdater).dump());
        }
        return buffer.toString();
    }

    final void archive(Datasource datasource, double value, long numUpdates) throws IOException {
        int dsIndex = this.getDsIndex(datasource.getName());
        for (Archive archive : this.archives) {
            archive.archive(dsIndex, value, numUpdates);
        }
    }

    public int getDsIndex(String dsName) throws IOException {
        for (int i = 0; i < this.datasources.length; ++i) {
            if (!this.datasources[i].getName().equals(dsName)) continue;
            return i;
        }
        throw new IllegalArgumentException("Unknown datasource name: " + dsName);
    }

    public boolean containsDs(String dsName) throws IOException {
        for (Datasource datasource : this.datasources) {
            if (!datasource.getName().equals(dsName)) continue;
            return true;
        }
        return false;
    }

    Datasource[] getDatasources() {
        return this.datasources;
    }

    Archive[] getArchives() {
        return this.archives;
    }

    public synchronized void dumpXml(OutputStream destination) throws IOException {
        XmlWriter writer = new XmlWriter(destination);
        writer.startTag("rrd");
        this.header.appendXml(writer);
        for (Datasource datasource : this.datasources) {
            datasource.appendXml(writer);
        }
        for (RrdUpdater rrdUpdater : this.archives) {
            ((Archive)rrdUpdater).appendXml(writer);
        }
        writer.closeTag();
        writer.flush();
    }

    public synchronized void exportXml(OutputStream destination) throws IOException {
        this.dumpXml(destination);
    }

    public synchronized String getXml() throws IOException {
        ByteArrayOutputStream destination = new ByteArrayOutputStream(100000);
        this.dumpXml(destination);
        return destination.toString();
    }

    public synchronized String exportXml() throws IOException {
        return this.getXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dumpXml(String filename) throws IOException {
        FileOutputStream outputStream = null;
        try {
            outputStream = new FileOutputStream(filename, false);
            this.dumpXml(outputStream);
        }
        finally {
            if (outputStream != null) {
                ((OutputStream)outputStream).close();
            }
        }
    }

    public synchronized void exportXml(String filename) throws IOException {
        this.dumpXml(filename);
    }

    public synchronized long getLastUpdateTime() throws IOException {
        return this.header.getLastUpdateTime();
    }

    public synchronized RrdDef getRrdDef() throws IOException {
        long startTime = this.header.getLastUpdateTime();
        long step = this.header.getStep();
        int version = this.header.getVersion();
        String path = this.backend.getPath();
        RrdDef rrdDef = new RrdDef(path, startTime, step, version);
        for (Datasource datasource : this.datasources) {
            DsDef dsDef = new DsDef(datasource.getName(), datasource.getType(), datasource.getHeartbeat(), datasource.getMinValue(), datasource.getMaxValue());
            rrdDef.addDatasource(dsDef);
        }
        for (RrdUpdater rrdUpdater : this.archives) {
            ArcDef arcDef = new ArcDef(((Archive)rrdUpdater).getConsolFun(), ((Archive)rrdUpdater).getXff(), ((Archive)rrdUpdater).getSteps(), ((Archive)rrdUpdater).getRows());
            rrdDef.addArchive(arcDef);
        }
        return rrdDef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public synchronized void copyStateTo(RrdUpdater other) throws IOException {
        int j;
        int i;
        if (!(other instanceof RrdDb)) {
            throw new IllegalArgumentException("Cannot copy RrdDb object to " + other.getClass().getName());
        }
        RrdDb otherRrd = (RrdDb)other;
        this.header.copyStateTo(otherRrd.header);
        for (i = 0; i < this.datasources.length; ++i) {
            j = Util.getMatchingDatasourceIndex(this, i, otherRrd);
            if (j < 0) continue;
            this.datasources[i].copyStateTo(otherRrd.datasources[j]);
        }
        for (i = 0; i < this.archives.length; ++i) {
            j = Util.getMatchingArchiveIndex(this, i, otherRrd);
            if (j < 0) continue;
            this.archives[i].copyStateTo(otherRrd.archives[j]);
        }
    }

    public Datasource getDatasource(String dsName) throws IOException {
        try {
            return this.getDatasource(this.getDsIndex(dsName));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int getArcIndex(ConsolFun consolFun, int steps) throws IOException {
        for (int i = 0; i < this.archives.length; ++i) {
            if (this.archives[i].getConsolFun() != consolFun || this.archives[i].getSteps() != steps) continue;
            return i;
        }
        throw new IllegalArgumentException("Could not find archive " + (Object)((Object)consolFun) + "/" + steps);
    }

    public Archive getArchive(ConsolFun consolFun, int steps) throws IOException {
        try {
            return this.getArchive(this.getArcIndex(consolFun, steps));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public String getCanonicalPath() throws IOException {
        if (this.backend instanceof RrdFileBackend) {
            return ((RrdFileBackend)this.backend).getCanonicalPath();
        }
        throw new IOException("The underlying backend has no canonical path");
    }

    public String getPath() {
        return this.backend.getPath();
    }

    @Override
    public RrdBackend getRrdBackend() {
        return this.backend;
    }

    @Override
    public RrdAllocator getRrdAllocator() {
        return this.allocator;
    }

    public synchronized byte[] getBytes() throws IOException {
        return this.backend.readAll();
    }

    public static void setDefaultFactory(String factoryName) {
        RrdBackendFactory.setDefaultFactory(factoryName);
    }

    public synchronized double[] getLastDatasourceValues() throws IOException {
        double[] values = new double[this.datasources.length];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this.datasources[i].getLastValue();
        }
        return values;
    }

    public synchronized double getLastDatasourceValue(String dsName) throws IOException {
        int dsIndex = this.getDsIndex(dsName);
        return this.datasources[dsIndex].getLastValue();
    }

    public int getDsCount() {
        return this.datasources.length;
    }

    public int getArcCount() {
        return this.archives.length;
    }

    public long getLastArchiveUpdateTime() throws IOException {
        long last = 0L;
        for (Archive archive : this.archives) {
            last = Math.max(last, archive.getEndTime());
        }
        return last;
    }

    public synchronized String getInfo() throws IOException {
        return this.header.getInfo();
    }

    public synchronized void setInfo(String info) throws IOException {
        this.header.setInfo(info);
    }

    public static void main(String[] args) {
        System.out.println("RRD4J :: RRDTool choice for the Java world");
        System.out.println("===============================================================================");
        System.out.println("RRD4J base directory: " + Util.getRrd4jHomeDirectory());
        long time = Util.getTime();
        System.out.println("Current time: " + time + ": " + new Date(time * 1000L));
        System.out.println("-------------------------------------------------------------------------------");
        System.out.println("See http://code.google.com/p/rrd4j/ for more information and the latest version.");
        System.out.println("Copyright 2011 Sasa Markovic and Mathias Bogaert. Licensed under the Apache License, Version 2.0.");
    }
}

