/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractResourceScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileScannerPlugin
extends AbstractResourceScannerPlugin<File, FileDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileScannerPlugin.class);

    public boolean accepts(File item, String path, Scope scope) throws IOException {
        return !item.isDirectory();
    }

    public FileDescriptor scan(File file, String path, Scope scope, Scanner scanner) throws IOException {
        String normalizedPath = this.slashify(path);
        LOGGER.debug("Scanning '{}'.", (Object)normalizedPath);
        try (RealFileResource fileResource = new RealFileResource(file);){
            FileDescriptor fileDescriptor = (FileDescriptor)scanner.scan((Object)fileResource, normalizedPath, scope);
            return fileDescriptor;
        }
    }

    private static class RealFileResource
    implements FileResource {
        private final File file;

        public RealFileResource(File file) {
            this.file = file;
        }

        @Override
        public InputStream createStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public File getFile() {
            return this.file;
        }

        @Override
        public void close() {
        }

        public String toString() {
            return this.file.toString();
        }
    }
}

