/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.DefaultFileResolver;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FilePatternMatcher;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import java.io.IOException;

public class FileResourceScannerPlugin
extends AbstractScannerPlugin<FileResource, FileDescriptor> {
    public static final String PROPERTY_INCLUDE = "file.include";
    public static final String PROPERTY_EXCLUDE = "file.exclude";
    private FilePatternMatcher filePatternMatcher;

    @Override
    protected void configure() {
        this.getScannerContext().push(FileResolver.class, (Object)new DefaultFileResolver());
        this.filePatternMatcher = FilePatternMatcher.Builder.newInstance().include(this.getStringProperty(PROPERTY_INCLUDE, null)).exclude(this.getStringProperty(PROPERTY_EXCLUDE, null)).build();
    }

    public boolean accepts(FileResource item, String path, Scope scope) throws IOException {
        return this.filePatternMatcher.accepts(path);
    }

    public FileDescriptor scan(FileResource item, String path, Scope scope, Scanner scanner) throws IOException {
        return ((FileResolver)scanner.getContext().peek(FileResolver.class)).match(path, FileDescriptor.class, scanner.getContext());
    }
}

