/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner.filesystem;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;

public class FilePatternMatcher {
    private Set<String> includeFilePatterns = null;
    private Set<String> excludeFilePatterns = null;

    private FilePatternMatcher() {
    }

    public boolean accepts(String path) {
        boolean result = this.includeFilePatterns != null ? this.matches(path, this.includeFilePatterns) : true;
        if (this.excludeFilePatterns != null) {
            result = result && !this.matches(path, this.excludeFilePatterns);
        }
        return result;
    }

    private boolean matches(String path, Set<String> filePatterns) {
        for (String filePattern : filePatterns) {
            if (!FilenameUtils.wildcardMatch((String)path, (String)filePattern, (IOCase)IOCase.SENSITIVE)) continue;
            return true;
        }
        return false;
    }

    public static class Builder {
        private FilePatternMatcher instance = new FilePatternMatcher();

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder include(String patternList) {
            this.instance.includeFilePatterns = this.parse(patternList);
            return this;
        }

        public Builder exclude(String patternList) {
            this.instance.excludeFilePatterns = this.parse(patternList);
            return this;
        }

        public FilePatternMatcher build() {
            return this.instance;
        }

        private Set<String> parse(String patternList) {
            if (patternList == null) {
                return null;
            }
            HashSet<String> patterns = new HashSet<String>();
            for (String pattern : patternList.split(",")) {
                String filePattern = pattern.trim();
                if (!StringUtils.isNotEmpty((String)filePattern)) continue;
                patterns.add(filePattern);
            }
            return patterns;
        }
    }
}

