/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ZipArchiveDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.FileResource;
import com.buschmais.jqassistant.plugin.common.api.scanner.filesystem.ZipFileResource;
import java.io.IOException;
import java.util.zip.ZipException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScannerPlugin.Requires(value={FileDescriptor.class})
public abstract class AbstractZipArchiveScannerPlugin<D extends ZipArchiveDescriptor>
extends AbstractScannerPlugin<FileResource, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractZipArchiveScannerPlugin.class);

    @Override
    public Class<? extends FileResource> getType() {
        return FileResource.class;
    }

    @Override
    public Class<D> getDescriptorType() {
        return this.getTypeParameter(AbstractZipArchiveScannerPlugin.class, 0);
    }

    public boolean accepts(FileResource file, String path, Scope scope) throws IOException {
        return path.toLowerCase().endsWith(this.getExtension());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public D scan(FileResource file, String path, Scope currentScope, Scanner scanner) throws IOException {
        ScannerContext scannerContext = scanner.getContext();
        FileDescriptor fileDescriptor = (FileDescriptor)scannerContext.peek(FileDescriptor.class);
        ZipArchiveDescriptor archive = (ZipArchiveDescriptor)scannerContext.getStore().addDescriptorType((Descriptor)fileDescriptor, this.getDescriptorType());
        scannerContext.push(ZipArchiveDescriptor.class, (Object)archive);
        Scope archiveScope = this.createScope(currentScope, archive, scannerContext);
        try (ZipFileResource zipFile = new ZipFileResource(file.getFile());){
            scanner.scan((Object)zipFile, path, archiveScope);
            archive.setValid(true);
        }
        catch (ZipException e) {
            LOGGER.warn("Cannot read ZIP file '" + path + "'.", (Throwable)e);
            archive.setValid(false);
        }
        finally {
            this.destroyScope(scannerContext);
            scannerContext.pop(ZipArchiveDescriptor.class);
        }
        return (D)archive;
    }

    protected abstract String getExtension();

    protected abstract Scope createScope(Scope var1, D var2, ScannerContext var3);

    protected abstract void destroyScope(ScannerContext var1);
}

