/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.common.api.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.ScannerPlugin;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScannerPlugin<I, D extends Descriptor>
implements ScannerPlugin<I, D> {
    private static Logger LOGGER = LoggerFactory.getLogger(AbstractScannerPlugin.class);
    private Map<String, Object> properties;
    private ScannerContext scannerContext;

    public void initialize() {
    }

    public final void configure(ScannerContext scannerContext, Map<String, Object> properties) {
        this.scannerContext = scannerContext;
        this.properties = properties;
        this.configure();
    }

    protected void configure() {
    }

    public Class<? extends I> getType() {
        return this.getTypeParameter(AbstractScannerPlugin.class, 0);
    }

    public Class<D> getDescriptorType() {
        return this.getTypeParameter(AbstractScannerPlugin.class, 1);
    }

    protected <T> Class<T> getTypeParameter(Class<?> expectedSuperClass, int genericTypeParameterIndex) {
        Class<?> thisClass = this.getClass();
        if (!thisClass.getSuperclass().equals(expectedSuperClass)) {
            throw new IllegalStateException("Cannot determine type argument of " + thisClass.getName());
        }
        Type genericSuperclass = thisClass.getGenericSuperclass();
        Type typeParameter = ((ParameterizedType)genericSuperclass).getActualTypeArguments()[genericTypeParameterIndex];
        if (typeParameter instanceof ParameterizedType) {
            return (Class)((ParameterizedType)typeParameter).getRawType();
        }
        return (Class)typeParameter;
    }

    protected Map<String, Object> getProperties() {
        return this.properties;
    }

    protected <T> T getProperty(String name, Class<T> type) {
        return type.cast(this.properties.get(name));
    }

    protected String getStringProperty(String name, String defaultValue) {
        Object value = this.properties.get(name);
        return value != null ? value.toString() : defaultValue;
    }

    protected Boolean getBooleanProperty(String name, Boolean defaultValue) {
        Object value = this.properties.get(name);
        return value != null ? Boolean.valueOf(value.toString()) : defaultValue;
    }

    protected ScannerContext getScannerContext() {
        return this.scannerContext;
    }

    protected String getDirectoryPath(File directory, File entry) {
        String relativePath;
        if (entry.equals(directory)) {
            relativePath = "/";
        } else {
            String filePath = entry.getAbsolutePath();
            String directoryPath = directory.getAbsolutePath();
            relativePath = filePath.substring(directoryPath.length()).replace(File.separator, "/");
        }
        return relativePath;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }
}

