/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WhitespaceTokenizer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.Version;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.PrefetchingResourceIterator;
import org.neo4j.index.impl.lucene.IndexClockCache;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexReference;
import org.neo4j.index.impl.lucene.IndexReferenceFactory;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.IndexTypeCache;
import org.neo4j.index.impl.lucene.ReadOnlyIndexReferenceFactory;
import org.neo4j.index.impl.lucene.WritableIndexReferenceFactory;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.factory.GraphDatabaseFacadeFactory;
import org.neo4j.kernel.impl.index.IndexConfigStore;
import org.neo4j.kernel.impl.index.IndexEntityType;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class LuceneDataSource
extends LifecycleAdapter {
    public static final Version LUCENE_VERSION = Version.LUCENE_36;
    public static final Analyzer LOWER_CASE_WHITESPACE_ANALYZER = new Analyzer(){

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new LowerCaseFilter(LUCENE_VERSION, (TokenStream)new WhitespaceTokenizer(LUCENE_VERSION, reader));
        }

        public String toString() {
            return "LOWER_CASE_WHITESPACE_ANALYZER";
        }
    };
    public static final Analyzer WHITESPACE_ANALYZER = new Analyzer(){

        public TokenStream tokenStream(String fieldName, Reader reader) {
            return new WhitespaceTokenizer(LUCENE_VERSION, reader);
        }

        public String toString() {
            return "WHITESPACE_ANALYZER";
        }
    };
    public static final Analyzer KEYWORD_ANALYZER = new KeywordAnalyzer();
    private final File storeDir;
    private final Config config;
    private final FileSystemAbstraction fileSystemAbstraction;
    private IndexClockCache indexSearchers;
    private File baseStorePath;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    final IndexConfigStore indexStore;
    private IndexTypeCache typeCache;
    private boolean readOnly;
    private boolean closed;
    private LuceneFilesystemFacade filesystemFacade;
    private IndexReferenceFactory indexReferenceFactory;

    public LuceneDataSource(File storeDir, Config config, IndexConfigStore indexStore, FileSystemAbstraction fileSystemAbstraction) {
        this.storeDir = storeDir;
        this.config = config;
        this.indexStore = indexStore;
        this.typeCache = new IndexTypeCache(indexStore);
        this.fileSystemAbstraction = fileSystemAbstraction;
    }

    public void init() {
        this.filesystemFacade = (Boolean)this.config.get(Configuration.ephemeral) != false ? LuceneFilesystemFacade.MEMORY : LuceneFilesystemFacade.FS;
        this.readOnly = (Boolean)this.config.get(GraphDatabaseSettings.read_only);
        this.indexSearchers = new IndexClockCache((Integer)this.config.get(Configuration.lucene_searcher_cache_size));
        this.baseStorePath = this.filesystemFacade.ensureDirectoryExists(this.fileSystemAbstraction, this.baseDirectory(this.storeDir));
        this.filesystemFacade.cleanWriteLocks(this.baseStorePath);
        this.typeCache = new IndexTypeCache(this.indexStore);
        this.indexReferenceFactory = this.readOnly ? new ReadOnlyIndexReferenceFactory(this.filesystemFacade, this.baseStorePath, this.typeCache) : new WritableIndexReferenceFactory(this.filesystemFacade, this.baseStorePath, this.typeCache);
        this.closed = false;
    }

    private File baseDirectory(File storeDir) {
        return new File(storeDir, "index");
    }

    IndexType getType(IndexIdentifier identifier, boolean recovery) {
        return this.typeCache.getIndexType(identifier, recovery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws IOException {
        LuceneDataSource luceneDataSource = this;
        synchronized (luceneDataSource) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (IndexReference searcher : this.indexSearchers.values()) {
                searcher.dispose();
            }
            this.indexSearchers.clear();
        }
    }

    private synchronized IndexReference[] getAllIndexes() {
        Collection indexReferences = this.indexSearchers.values();
        return indexReferences.toArray(new IndexReference[indexReferences.size()]);
    }

    void force() {
        if (this.readOnly) {
            return;
        }
        for (IndexReference index : this.getAllIndexes()) {
            try {
                index.getWriter().commit();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to commit changes to " + index.getIdentifier() + " in " + ((File)this.config.get(GraphDatabaseSettings.store_dir)).getAbsolutePath(), e);
            }
        }
    }

    void getReadLock() {
        this.lock.readLock().lock();
    }

    void releaseReadLock() {
        this.lock.readLock().unlock();
    }

    void getWriteLock() {
        this.lock.writeLock().lock();
    }

    void releaseWriteLock() {
        this.lock.writeLock().unlock();
    }

    static File getFileDirectory(File storeDir, IndexEntityType type) {
        File path = new File(storeDir, "lucene");
        String extra = type.nameToLowerCase();
        return new File(path, extra);
    }

    static File getFileDirectory(File storeDir, IndexIdentifier identifier) {
        return new File(LuceneDataSource.getFileDirectory(storeDir, identifier.entityType), identifier.indexName);
    }

    static Directory getDirectory(File storeDir, IndexIdentifier identifier) throws IOException {
        return FSDirectory.open((File)LuceneDataSource.getFileDirectory(storeDir, identifier));
    }

    static TopFieldCollector scoringCollector(Sort sorting, int n) throws IOException {
        return TopFieldCollector.create((Sort)sorting, (int)n, (boolean)false, (boolean)true, (boolean)false, (boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexReference getIndexSearcher(IndexIdentifier identifier) {
        this.assertNotClosed();
        IndexReference searcher = (IndexReference)this.indexSearchers.get(identifier);
        if (searcher == null) {
            return this.syncGetIndexSearcher(identifier);
        }
        IndexReference indexReference = searcher;
        synchronized (indexReference) {
            searcher = (IndexReference)this.indexSearchers.get(identifier);
            if (searcher == null || searcher.isClosed()) {
                return this.syncGetIndexSearcher(identifier);
            }
            searcher = this.refreshSearcherIfNeeded(searcher);
            searcher.incRef();
            return searcher;
        }
    }

    private void assertNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("Lucene index provider has been shut down");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized IndexReference syncGetIndexSearcher(IndexIdentifier identifier) {
        try {
            IndexReference indexReference = (IndexReference)this.indexSearchers.get(identifier);
            if (indexReference == null) {
                indexReference = this.indexReferenceFactory.createIndexReference(identifier);
                this.indexSearchers.put(identifier, indexReference);
            } else if (!this.readOnly) {
                IndexReference indexReference2 = indexReference;
                synchronized (indexReference2) {
                    indexReference = this.refreshSearcherIfNeeded(indexReference);
                }
            }
            indexReference.incRef();
            return indexReference;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private IndexReference refreshSearcherIfNeeded(IndexReference searcher) {
        if (searcher.checkAndClearStale() && (searcher = this.indexReferenceFactory.refresh(searcher)) != null) {
            this.indexSearchers.put(searcher.getIdentifier(), searcher);
        }
        return searcher;
    }

    void invalidateIndexSearcher(IndexIdentifier identifier) {
        IndexReference searcher = (IndexReference)this.indexSearchers.get(identifier);
        if (searcher != null) {
            searcher.setStale();
        }
    }

    void deleteIndex(IndexIdentifier identifier, boolean recovery) throws IOException {
        boolean removeFromIndexStore;
        if (this.readOnly) {
            throw new IllegalStateException("Index deletion in read only mode is not supported.");
        }
        this.closeIndex(identifier);
        FileUtils.deleteRecursively((File)LuceneDataSource.getFileDirectory(this.baseStorePath, identifier));
        boolean bl = removeFromIndexStore = !recovery || this.indexStore.has(identifier.entityType.entityClass(), identifier.indexName);
        if (removeFromIndexStore) {
            this.indexStore.remove(identifier.entityType.entityClass(), identifier.indexName);
        }
        this.typeCache.invalidate(identifier);
    }

    static Document findDocument(IndexType type, IndexSearcher searcher, long entityId) {
        try {
            TopDocs docs = searcher.search(type.idTermQuery(entityId), 1);
            if (docs.scoreDocs.length > 0) {
                return searcher.doc(docs.scoreDocs[0].doc);
            }
            return null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean documentIsEmpty(Document document) {
        List fields = document.getFields();
        for (Fieldable field : fields) {
            if ("_id_".equals(field.name()) || "_end_node_id_".equals(field.name()) || "_start_node_id_".equals(field.name())) continue;
            return false;
        }
        return true;
    }

    private synchronized void closeIndex(IndexIdentifier identifier) {
        try {
            IndexReference searcher = (IndexReference)this.indexSearchers.remove(identifier);
            if (searcher != null) {
                searcher.dispose();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to close lucene writer " + identifier, e);
        }
    }

    public ResourceIterator<File> listStoreFiles(boolean includeLogicalLogs) throws IOException {
        final ArrayList<File> files = new ArrayList<File>();
        final ArrayList<SnapshotDeletionPolicy> snapshots = new ArrayList<SnapshotDeletionPolicy>();
        this.makeSureAllIndexesAreInstantiated();
        for (IndexReference writer : this.getAllIndexes()) {
            IndexCommit commit;
            SnapshotDeletionPolicy deletionPolicy = (SnapshotDeletionPolicy)writer.getWriter().getConfig().getIndexDeletionPolicy();
            File indexDirectory = LuceneDataSource.getFileDirectory(this.baseStorePath, writer.getIdentifier());
            try {
                commit = deletionPolicy.snapshot("backup");
            }
            catch (IllegalStateException e) {
                writer.getWriter().commit();
                commit = deletionPolicy.snapshot("backup");
            }
            for (String fileName : commit.getFileNames()) {
                files.add(new File(indexDirectory, fileName));
            }
            snapshots.add(deletionPolicy);
        }
        return new PrefetchingResourceIterator<File>(){
            private final Iterator<File> filesIterator;
            {
                this.filesIterator = files.iterator();
            }

            protected File fetchNextOrNull() {
                return this.filesIterator.hasNext() ? this.filesIterator.next() : null;
            }

            public void close() {
                for (SnapshotDeletionPolicy deletionPolicy : snapshots) {
                    try {
                        deletionPolicy.release("backup");
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
    }

    public ResourceIterator<File> listStoreFiles() throws IOException {
        return this.listStoreFiles(false);
    }

    private void makeSureAllIndexesAreInstantiated() {
        IndexIdentifier identifier;
        Map config;
        for (String name : this.indexStore.getNames(Node.class)) {
            config = this.indexStore.get(Node.class, name);
            if (!((String)config.get("provider")).equals("lucene")) continue;
            identifier = new IndexIdentifier(IndexEntityType.Node, name);
            this.getIndexSearcher(identifier);
        }
        for (String name : this.indexStore.getNames(Relationship.class)) {
            config = this.indexStore.get(Relationship.class, name);
            if (!((String)config.get("provider")).equals("lucene")) continue;
            identifier = new IndexIdentifier(IndexEntityType.Relationship, name);
            this.getIndexSearcher(identifier);
        }
    }

    static enum LuceneFilesystemFacade {
        FS{

            @Override
            Directory getDirectory(File baseStorePath, IndexIdentifier identifier) throws IOException {
                return FSDirectory.open((File)LuceneDataSource.getFileDirectory(baseStorePath, identifier));
            }

            @Override
            void cleanWriteLocks(File dir) {
                if (!dir.isDirectory()) {
                    return;
                }
                for (File file : dir.listFiles()) {
                    if (file.isDirectory()) {
                        this.cleanWriteLocks(file);
                        continue;
                    }
                    if (!file.getName().equals("write.lock")) continue;
                    boolean success = file.delete();
                    assert (success);
                }
            }

            @Override
            File ensureDirectoryExists(FileSystemAbstraction fileSystem, File dir) {
                if (!dir.exists() && !dir.mkdirs()) {
                    String message = String.format("Unable to create directory path[%s] for Neo4j store.", dir.getAbsolutePath());
                    throw new RuntimeException(message);
                }
                return dir;
            }
        }
        ,
        MEMORY{

            @Override
            Directory getDirectory(File baseStorePath, IndexIdentifier identifier) {
                return new RAMDirectory();
            }

            @Override
            void cleanWriteLocks(File path) {
            }

            @Override
            File ensureDirectoryExists(FileSystemAbstraction fileSystem, File path) {
                try {
                    fileSystem.mkdirs(path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return path;
            }
        };


        abstract Directory getDirectory(File var1, IndexIdentifier var2) throws IOException;

        abstract File ensureDirectoryExists(FileSystemAbstraction var1, File var2);

        abstract void cleanWriteLocks(File var1);
    }

    public static abstract class Configuration {
        public static final Setting<Integer> lucene_searcher_cache_size = GraphDatabaseSettings.lucene_searcher_cache_size;
        public static final Setting<Boolean> ephemeral = GraphDatabaseFacadeFactory.Configuration.ephemeral;
    }
}

