/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.File;
import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.Directory;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexReference;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.IndexTypeCache;
import org.neo4j.index.impl.lucene.LuceneDataSource;

abstract class IndexReferenceFactory {
    private final File baseStorePath;
    private final IndexTypeCache typeCache;
    private final LuceneDataSource.LuceneFilesystemFacade filesystemFacade;

    IndexReferenceFactory(LuceneDataSource.LuceneFilesystemFacade filesystemFacade, File baseStorePath, IndexTypeCache typeCache) {
        this.filesystemFacade = filesystemFacade;
        this.baseStorePath = baseStorePath;
        this.typeCache = typeCache;
    }

    abstract IndexReference createIndexReference(IndexIdentifier var1) throws IOException;

    abstract IndexReference refresh(IndexReference var1);

    Directory getIndexDirectory(IndexIdentifier identifier) throws IOException {
        return this.filesystemFacade.getDirectory(this.baseStorePath, identifier);
    }

    IndexSearcher newIndexSearcher(IndexIdentifier identifier, IndexReader reader) {
        IndexSearcher searcher = new IndexSearcher(reader);
        IndexType type = this.getType(identifier);
        if (type.getSimilarity() != null) {
            searcher.setSimilarity(type.getSimilarity());
        }
        return searcher;
    }

    IndexType getType(IndexIdentifier identifier) {
        return this.typeCache.getIndexType(identifier, false);
    }
}

