/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.compiler.v1_9.executionplan.builders;

import org.neo4j.cypher.MissingIndexException;
import org.neo4j.cypher.internal.compiler.v1_9.ExecutionContext;
import org.neo4j.cypher.internal.compiler.v1_9.commands.NodeById;
import org.neo4j.cypher.internal.compiler.v1_9.commands.NodeByIndex;
import org.neo4j.cypher.internal.compiler.v1_9.commands.NodeByIndexQuery;
import org.neo4j.cypher.internal.compiler.v1_9.commands.RelationshipByIndex;
import org.neo4j.cypher.internal.compiler.v1_9.commands.RelationshipByIndexQuery;
import org.neo4j.cypher.internal.compiler.v1_9.commands.StartItem;
import org.neo4j.cypher.internal.compiler.v1_9.commands.expressions.Expression;
import org.neo4j.cypher.internal.compiler.v1_9.executionplan.builders.GetGraphElements$;
import org.neo4j.cypher.internal.compiler.v1_9.pipes.QueryState;
import org.neo4j.cypher.internal.compiler.v1_9.spi.Operations;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import scala.Function2;
import scala.MatchError;
import scala.Serializable;
import scala.collection.Iterator;
import scala.reflect.ManifestFactory$;

public final class IndexQueryBuilder$ {
    public static final IndexQueryBuilder$ MODULE$;

    static {
        new IndexQueryBuilder$();
    }

    public Function2<ExecutionContext, QueryState, Iterator<Node>> getNodeGetter(StartItem startItem, GraphDatabaseService graph) {
        StartItem startItem2;
        block5: {
            Object object;
            block3: {
                block4: {
                    block2: {
                        startItem2 = startItem;
                        if (!(startItem2 instanceof NodeByIndex)) break block2;
                        NodeByIndex nodeByIndex = (NodeByIndex)startItem2;
                        String idxName = nodeByIndex.idxName();
                        Expression key = nodeByIndex.key();
                        Expression value = nodeByIndex.expression();
                        this.checkNodeIndex(idxName, graph);
                        object = new Serializable(idxName, key, value){
                            public static final long serialVersionUID = 0L;
                            private final String idxName$1;
                            private final Expression key$1;
                            private final Expression value$1;

                            public final Iterator<Node> apply(ExecutionContext m, QueryState state) {
                                String keyVal = this.key$1.apply(m, state).toString();
                                Object valueVal = this.value$1.apply(m, state);
                                return state.query().nodeOps().indexGet(this.idxName$1, keyVal, valueVal);
                            }
                            {
                                this.idxName$1 = idxName$1;
                                this.key$1 = key$1;
                                this.value$1 = value$1;
                            }
                        };
                        break block3;
                    }
                    if (!(startItem2 instanceof NodeByIndexQuery)) break block4;
                    NodeByIndexQuery nodeByIndexQuery = (NodeByIndexQuery)startItem2;
                    String idxName = nodeByIndexQuery.idxName();
                    Expression query2 = nodeByIndexQuery.query();
                    this.checkNodeIndex(idxName, graph);
                    object = new Serializable(idxName, query2){
                        public static final long serialVersionUID = 0L;
                        private final String idxName$2;
                        private final Expression query$1;

                        public final Iterator<Node> apply(ExecutionContext m, QueryState state) {
                            Object queryText = this.query$1.apply(m, state);
                            return state.query().nodeOps().indexQuery(this.idxName$2, queryText);
                        }
                        {
                            this.idxName$2 = idxName$2;
                            this.query$1 = query$1;
                        }
                    };
                    break block3;
                }
                if (!(startItem2 instanceof NodeById)) break block5;
                NodeById nodeById = (NodeById)startItem2;
                String varName = nodeById.varName();
                Expression ids2 = nodeById.expression();
                object = new Serializable(varName, ids2){
                    public static final long serialVersionUID = 0L;
                    private final String varName$1;
                    private final Expression ids$1;

                    public final Iterator<Node> apply(ExecutionContext m, QueryState state) {
                        Operations<Node> operations = state.query().nodeOps();
                        return GetGraphElements$.MODULE$.getElements(this.ids$1.apply(m, state), this.varName$1, new Serializable(this, operations){
                            public static final long serialVersionUID = 0L;
                            private final Operations eta$0$1$1;

                            public final Node apply(long id2) {
                                return (Node)this.eta$0$1$1.getById(id2);
                            }
                            {
                                this.eta$0$1$1 = eta$0$1$1;
                            }
                        }, ManifestFactory$.MODULE$.classType(Node.class));
                    }
                    {
                        this.varName$1 = varName$1;
                        this.ids$1 = ids$1;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)startItem2);
    }

    public Function2<ExecutionContext, QueryState, Iterator<Relationship>> getRelationshipGetter(StartItem startItem, GraphDatabaseService graph) {
        StartItem startItem2;
        block4: {
            Object object;
            block3: {
                block2: {
                    startItem2 = startItem;
                    if (!(startItem2 instanceof RelationshipByIndex)) break block2;
                    RelationshipByIndex relationshipByIndex = (RelationshipByIndex)startItem2;
                    String idxName = relationshipByIndex.idxName();
                    Expression key = relationshipByIndex.key();
                    Expression value = relationshipByIndex.expression();
                    this.checkRelIndex(idxName, graph);
                    object = new Serializable(idxName, key, value){
                        public static final long serialVersionUID = 0L;
                        private final String idxName$3;
                        private final Expression key$2;
                        private final Expression value$2;

                        public final Iterator<Relationship> apply(ExecutionContext m, QueryState state) {
                            String keyVal = this.key$2.apply(m, state).toString();
                            Object valueVal = this.value$2.apply(m, state);
                            return state.query().relationshipOps().indexGet(this.idxName$3, keyVal, valueVal);
                        }
                        {
                            this.idxName$3 = idxName$3;
                            this.key$2 = key$2;
                            this.value$2 = value$2;
                        }
                    };
                    break block3;
                }
                if (!(startItem2 instanceof RelationshipByIndexQuery)) break block4;
                RelationshipByIndexQuery relationshipByIndexQuery = (RelationshipByIndexQuery)startItem2;
                String idxName = relationshipByIndexQuery.idxName();
                Expression query2 = relationshipByIndexQuery.query();
                this.checkRelIndex(idxName, graph);
                object = new Serializable(idxName, query2){
                    public static final long serialVersionUID = 0L;
                    private final String idxName$4;
                    private final Expression query$2;

                    public final Iterator<Relationship> apply(ExecutionContext m, QueryState state) {
                        Object queryText = this.query$2.apply(m, state);
                        return state.query().relationshipOps().indexQuery(this.idxName$4, queryText);
                    }
                    {
                        this.idxName$4 = idxName$4;
                        this.query$2 = query$2;
                    }
                };
            }
            return object;
        }
        throw new MatchError((Object)startItem2);
    }

    private void checkNodeIndex(String idxName, GraphDatabaseService graph) {
        if (graph.index().existsForNodes(idxName)) {
            return;
        }
        throw new MissingIndexException(idxName);
    }

    private void checkRelIndex(String idxName, GraphDatabaseService graph) {
        if (graph.index().existsForRelationships(idxName)) {
            return;
        }
        throw new MissingIndexException(idxName);
    }

    private IndexQueryBuilder$() {
        MODULE$ = this;
    }
}

