/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.aether.artifact.Artifact;

public class RepositoryArtifactCoordinates
implements Coordinates {
    private static final String DATEFORMAT_TIMESTAMP_SNAPSHOT = "yyyyMMddHHmmss";
    private Artifact artifact;
    private long lastModified;

    public RepositoryArtifactCoordinates(Artifact artifact, long lastModified) {
        this.artifact = artifact;
        this.lastModified = lastModified;
    }

    public String getGroup() {
        return this.artifact.getGroupId();
    }

    public String getName() {
        return this.artifact.getArtifactId();
    }

    public String getClassifier() {
        return this.artifact.getClassifier();
    }

    public String getType() {
        return this.artifact.getExtension();
    }

    public String getVersion() {
        if (this.artifact.isSnapshot()) {
            String timeStamp = new SimpleDateFormat(DATEFORMAT_TIMESTAMP_SNAPSHOT).format(new Date(this.lastModified));
            return this.artifact.getBaseVersion() + "-" + timeStamp;
        }
        return this.artifact.getVersion();
    }
}

