/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.MavenRepositoryFileResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenArtifactHelper;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import java.io.File;
import org.apache.commons.lang.StringUtils;

public class MavenRepositoryArtifactResolver
implements ArtifactResolver {
    private MavenRepositoryFileResolver repositoryFileResolver;
    private String repositoryRoot;

    public MavenRepositoryArtifactResolver(File repositoryRoot, MavenRepositoryFileResolver repositoryFileResolver) {
        this.repositoryFileResolver = repositoryFileResolver;
        this.repositoryRoot = repositoryRoot.getAbsolutePath().replace('\\', '/');
    }

    public MavenArtifactDescriptor resolve(Coordinates coordinates, ScannerContext scannerContext) {
        String fileName = this.getFileName(coordinates);
        MavenArtifactDescriptor mavenArtifactDescriptor = (MavenArtifactDescriptor)this.repositoryFileResolver.require(fileName, MavenArtifactDescriptor.class, scannerContext);
        MavenArtifactHelper.setCoordinates((MavenArtifactDescriptor)mavenArtifactDescriptor, (Coordinates)coordinates);
        return mavenArtifactDescriptor;
    }

    private String getFileName(Coordinates coordinates) {
        String group = coordinates.getGroup();
        String name = coordinates.getName();
        String version = coordinates.getVersion();
        String classifier = coordinates.getClassifier();
        String type = coordinates.getType();
        StringBuilder fileName = new StringBuilder();
        fileName.append(this.repositoryRoot);
        if (StringUtils.isNotEmpty((String)group)) {
            fileName.append('/');
            fileName.append(group.replace('.', '/'));
        }
        fileName.append('/');
        fileName.append(name);
        if (StringUtils.isNotEmpty((String)version)) {
            fileName.append('/');
            fileName.append(version);
        }
        fileName.append('/');
        fileName.append(name);
        if (StringUtils.isNotEmpty((String)version)) {
            fileName.append('-');
            fileName.append(version);
        }
        if (StringUtils.isNotEmpty((String)classifier)) {
            fileName.append('-');
            fileName.append(classifier);
        }
        fileName.append('.');
        fileName.append(type);
        return fileName.toString();
    }
}

