/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.m2repo.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.common.api.scanner.FileResolver;
import com.buschmais.jqassistant.plugin.m2repo.api.ArtifactProvider;
import com.buschmais.jqassistant.plugin.m2repo.api.model.MavenReleaseDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.api.model.MavenRepositoryDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.api.model.MavenSnapshotDescriptor;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.ArtifactCoordinates;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.ArtifactFilter;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.EffectiveModelBuilder;
import com.buschmais.jqassistant.plugin.m2repo.impl.scanner.RepositoryArtifactCoordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.Coordinates;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.MavenArtifactHelper;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomXmlDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.PomModelBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.MAVEN;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenArtifactScannerPlugin
extends AbstractScannerPlugin<ArtifactInfo, MavenArtifactDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenArtifactScannerPlugin.class);
    private static final String PROPERTY_NAME_ARTIFACTS_KEEP = "m2repo.artifacts.keep";
    private static final String PROPERTY_NAME_ARTIFACTS_SCAN = "m2repo.artifacts.scan";
    private static final String PROPERTY_NAME_FILTER_INCLUDES = "m2repo.filter.includes";
    private static final String PROPERTY_NAME_FILTER_EXCLUDES = "m2repo.filter.excludes";
    private boolean keepArtifacts;
    private boolean scanArtifacts;
    private ArtifactFilter artifactFilter;

    protected void configure() {
        super.configure();
        this.scanArtifacts = this.getBooleanProperty(PROPERTY_NAME_ARTIFACTS_SCAN, true);
        this.keepArtifacts = this.getBooleanProperty(PROPERTY_NAME_ARTIFACTS_KEEP, true);
        List<String> includeFilter = this.getFilterPattern(PROPERTY_NAME_FILTER_INCLUDES);
        List<String> excludeFilter = this.getFilterPattern(PROPERTY_NAME_FILTER_EXCLUDES);
        this.artifactFilter = new ArtifactFilter(includeFilter, excludeFilter);
    }

    public boolean accepts(ArtifactInfo item, String path, Scope scope) throws IOException {
        return item != null && MavenScope.REPOSITORY.equals((Object)scope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenArtifactDescriptor scan(ArtifactInfo item, String path, Scope scope, Scanner scanner) throws IOException {
        ArtifactProvider artifactProvider = (ArtifactProvider)scanner.getContext().peek(ArtifactProvider.class);
        scanner.getContext().push(FileResolver.class, (Object)artifactProvider.getFileResolver());
        scanner.getContext().push(ArtifactResolver.class, (Object)artifactProvider.getArtifactResolver());
        try {
            MavenArtifactDescriptor mavenArtifactDescriptor = this.resolveAndScan(scanner, artifactProvider, item);
            return mavenArtifactDescriptor;
        }
        finally {
            scanner.getContext().pop(ArtifactResolver.class);
            scanner.getContext().pop(FileResolver.class);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenArtifactDescriptor resolveAndScan(Scanner scanner, ArtifactProvider artifactProvider, ArtifactInfo artifactInfo) throws IOException {
        block13: {
            EffectiveModelBuilder pomModelBuilder = new EffectiveModelBuilder(artifactProvider);
            ScannerContext context = scanner.getContext();
            Store store = context.getStore();
            String groupId = artifactInfo.getFieldValue(MAVEN.GROUP_ID);
            String artifactId = artifactInfo.getFieldValue(MAVEN.ARTIFACT_ID);
            String classifier = artifactInfo.getFieldValue(MAVEN.CLASSIFIER);
            String packaging = artifactInfo.getFieldValue(MAVEN.PACKAGING);
            String version = artifactInfo.getFieldValue(MAVEN.VERSION);
            long lastModified = artifactInfo.lastModified;
            DefaultArtifact artifact = new DefaultArtifact(groupId, artifactId, classifier, packaging, version);
            if (this.artifactFilter.match(RepositoryUtils.toArtifact((Artifact)artifact))) {
                try {
                    Descriptor descriptor;
                    ArtifactResult modelArtifactResult = artifactProvider.getArtifact((Artifact)new DefaultArtifact(groupId, artifactId, null, "pom", version));
                    Artifact resolvedModelArtifact = modelArtifactResult.getArtifact();
                    MavenRepositoryDescriptor repositoryDescriptor = artifactProvider.getRepositoryDescriptor();
                    MavenPomXmlDescriptor modelDescriptor = this.findModel(repositoryDescriptor, resolvedModelArtifact);
                    if (modelDescriptor == null) {
                        File modelArtifactFile = resolvedModelArtifact.getFile();
                        context.push(PomModelBuilder.class, (Object)pomModelBuilder);
                        try {
                            modelDescriptor = (MavenPomXmlDescriptor)scanner.scan((Object)modelArtifactFile, modelArtifactFile.getAbsolutePath(), null);
                        }
                        finally {
                            context.pop(PomModelBuilder.class);
                            if (!this.keepArtifacts) {
                                modelArtifactFile.delete();
                            }
                        }
                        modelDescriptor = this.markReleaseOrSnaphot(modelDescriptor, MavenPomXmlDescriptor.class, resolvedModelArtifact, lastModified, store);
                        repositoryDescriptor.getContainedModels().add(modelDescriptor);
                    }
                    if (!this.scanArtifacts || artifact.getExtension().equals("pom")) break block13;
                    ArtifactResult artifactResult = artifactProvider.getArtifact((Artifact)artifact);
                    File artifactFile = artifactResult.getArtifact().getFile();
                    try {
                        descriptor = scanner.scan((Object)artifactFile, artifactFile.getAbsolutePath(), null);
                    }
                    finally {
                        if (!this.keepArtifacts) {
                            artifactFile.delete();
                        }
                    }
                    MavenArtifactDescriptor mavenArtifactDescriptor = this.markReleaseOrSnaphot((MavenDescriptor)store.addDescriptorType(descriptor, MavenArtifactDescriptor.class), MavenArtifactDescriptor.class, (Artifact)artifact, lastModified, store);
                    MavenArtifactHelper.setId((MavenArtifactDescriptor)mavenArtifactDescriptor, (Coordinates)new RepositoryArtifactCoordinates((Artifact)artifact, lastModified));
                    MavenArtifactHelper.setCoordinates((MavenArtifactDescriptor)mavenArtifactDescriptor, (Coordinates)new RepositoryArtifactCoordinates((Artifact)artifact, lastModified));
                    modelDescriptor.getDescribes().add(mavenArtifactDescriptor);
                    repositoryDescriptor.getContainedArtifacts().add(mavenArtifactDescriptor);
                    return mavenArtifactDescriptor;
                }
                catch (ArtifactResolutionException e) {
                    LOGGER.warn(e.getMessage());
                }
            }
        }
        return null;
    }

    private MavenPomXmlDescriptor findModel(MavenRepositoryDescriptor repositoryDescriptor, Artifact resolvedModelArtifact) {
        DefaultArtifact resolvedMainArtifact = new DefaultArtifact(resolvedModelArtifact.getGroupId(), resolvedModelArtifact.getArtifactId(), resolvedModelArtifact.getExtension(), resolvedModelArtifact.getVersion());
        String coordinates = MavenArtifactHelper.getId((Coordinates)new ArtifactCoordinates((Artifact)resolvedMainArtifact));
        return repositoryDescriptor.findModel(coordinates);
    }

    private <D extends MavenDescriptor> D markReleaseOrSnaphot(D descriptor, Class<? extends D> type, Artifact resolvedArtifact, long lastModified, Store store) {
        if (resolvedArtifact.isSnapshot()) {
            MavenSnapshotDescriptor snapshotDescriptor = (MavenSnapshotDescriptor)store.addDescriptorType(descriptor, MavenSnapshotDescriptor.class);
            snapshotDescriptor.setLastModified(lastModified);
            return (D)((MavenDescriptor)type.cast(snapshotDescriptor));
        }
        return (D)((MavenDescriptor)store.addDescriptorType(descriptor, MavenReleaseDescriptor.class, type));
    }

    private List<String> getFilterPattern(String propertyName) {
        String patterns = this.getStringProperty(propertyName, null);
        if (patterns == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String pattern : patterns.split(",")) {
            String trimmed = pattern.trim();
            if (trimmed.isEmpty()) continue;
            result.add(trimmed);
        }
        return result;
    }
}

