/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.impl.datastore;

import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.api.XOException;
import com.buschmais.xo.neo4j.impl.datastore.AbstractNeo4jPropertyManager;
import com.buschmais.xo.neo4j.impl.datastore.metadata.IndexedPropertyMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.PropertyMetadata;
import com.buschmais.xo.spi.datastore.DatastoreEntityManager;
import com.buschmais.xo.spi.datastore.TypeMetadataSet;
import com.buschmais.xo.spi.metadata.method.IndexedPropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.type.EntityTypeMetadata;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;

public class Neo4jEntityManager
extends AbstractNeo4jPropertyManager<Node>
implements DatastoreEntityManager<Long, Node, NodeMetadata, Label, PropertyMetadata> {
    private final GraphDatabaseService graphDatabaseService;
    private final Cache<Long, Set<Label>> labelCache;

    public Neo4jEntityManager(GraphDatabaseService graphDatabaseService) {
        this.graphDatabaseService = graphDatabaseService;
        this.labelCache = CacheBuilder.newBuilder().maximumSize(256L).build();
    }

    public boolean isEntity(Object o) {
        return Node.class.isAssignableFrom(o.getClass());
    }

    public Set<Label> getEntityDiscriminators(Node node) {
        HashSet<Label> labels = (HashSet<Label>)this.labelCache.getIfPresent((Object)node.getId());
        if (labels == null) {
            labels = new HashSet<Label>();
            for (Label label : node.getLabels()) {
                labels.add(label);
            }
            this.labelCache.put((Object)node.getId(), labels);
        }
        return labels;
    }

    public Long getEntityId(Node entity) {
        return entity.getId();
    }

    public Node createEntity(TypeMetadataSet<EntityTypeMetadata<NodeMetadata>> types, Set<Label> discriminators, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> example) {
        Node node = this.graphDatabaseService.createNode(discriminators.toArray(new Label[discriminators.size()]));
        this.setProperties(node, example);
        this.labelCache.put((Object)node.getId(), discriminators);
        return node;
    }

    public void deleteEntity(Node entity) {
        entity.delete();
        this.labelCache.invalidate((Object)entity.getId());
    }

    public Node findEntityById(EntityTypeMetadata<NodeMetadata> metadata, Label label, Long id) {
        return this.graphDatabaseService.getNodeById(id.longValue());
    }

    public ResultIterator<Node> findEntity(EntityTypeMetadata<NodeMetadata> entityTypeMetadata, Label discriminator, Map<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> values) {
        if (values.size() > 1) {
            throw new XOException("Only one property value is supported for find operation");
        }
        Map.Entry<PrimitivePropertyMethodMetadata<PropertyMetadata>, Object> entry = values.entrySet().iterator().next();
        PrimitivePropertyMethodMetadata propertyMethodMetadata = entry.getKey();
        if (propertyMethodMetadata == null) {
            IndexedPropertyMethodMetadata<IndexedPropertyMetadata> indexedProperty = ((NodeMetadata)entityTypeMetadata.getDatastoreMetadata()).getUsingIndexedPropertyOf();
            if (indexedProperty == null) {
                throw new XOException("Type " + ((Class)entityTypeMetadata.getAnnotatedType().getAnnotatedElement()).getName() + " has no indexed property.");
            }
            propertyMethodMetadata = indexedProperty.getPropertyMethodMetadata();
        }
        PropertyMetadata propertyMetadata = (PropertyMetadata)propertyMethodMetadata.getDatastoreMetadata();
        Object value = entry.getValue();
        final ResourceIterator iterator = this.graphDatabaseService.findNodes(discriminator, propertyMetadata.getName(), value);
        return new ResultIterator<Node>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Node next() {
                return (Node)iterator.next();
            }

            public void remove() {
                throw new XOException("Remove operation is not supported for find results.");
            }

            public void close() {
                iterator.close();
            }
        };
    }

    public void migrateEntity(Node entity, TypeMetadataSet<EntityTypeMetadata<NodeMetadata>> types, Set<Label> discriminators, TypeMetadataSet<EntityTypeMetadata<NodeMetadata>> targetTypes, Set<Label> targetDiscriminators) {
        HashSet<Label> labelsToRemove = new HashSet<Label>(discriminators);
        labelsToRemove.removeAll(targetDiscriminators);
        for (Label label : labelsToRemove) {
            entity.removeLabel(label);
        }
        HashSet<Label> labelsToAdd = new HashSet<Label>(targetDiscriminators);
        labelsToAdd.removeAll(discriminators);
        this.addDiscriminators(entity, labelsToAdd);
        this.labelCache.put((Object)entity.getId(), targetDiscriminators);
    }

    public void addDiscriminators(Node node, Set<Label> labels) {
        for (Label label : labels) {
            node.addLabel(label);
        }
        this.labelCache.invalidate((Object)node.getId());
    }

    public void removeDiscriminators(Node node, Set<Label> labels) {
        for (Label label : labels) {
            node.removeLabel(label);
        }
        this.labelCache.invalidate((Object)node.getId());
    }

    public void flushEntity(Node node) {
        this.labelCache.invalidate((Object)node.getId());
    }
}

