/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.neo4j.impl.datastore;

import com.buschmais.xo.api.ResultIterable;
import com.buschmais.xo.api.ResultIterator;
import com.buschmais.xo.neo4j.impl.datastore.metadata.NodeMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.PropertyMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.RelationshipMetadata;
import com.buschmais.xo.neo4j.impl.datastore.metadata.RelationshipType;
import com.buschmais.xo.spi.metadata.method.PrimitivePropertyMethodMetadata;
import com.buschmais.xo.spi.metadata.type.EntityTypeMetadata;
import com.buschmais.xo.spi.session.XOSession;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.ResourceIterator;

abstract class AbstractNeo4jRepositoryImpl {
    private final GraphDatabaseService graphDatabaseService;
    private final XOSession<Long, Node, NodeMetadata, Label, Long, Relationship, RelationshipMetadata, RelationshipType, PropertyMetadata> xoSession;

    protected AbstractNeo4jRepositoryImpl(GraphDatabaseService graphDatabaseService, XOSession<Long, Node, NodeMetadata, Label, Long, Relationship, RelationshipMetadata, RelationshipType, PropertyMetadata> xoSession) {
        this.graphDatabaseService = graphDatabaseService;
        this.xoSession = xoSession;
    }

    protected <T> ResultIterable<T> find(Class<T> type, Object value) {
        EntityTypeMetadata entityMetadata = this.xoSession.getEntityMetadata(type);
        Label label = ((NodeMetadata)entityMetadata.getDatastoreMetadata()).getDiscriminator();
        PrimitivePropertyMethodMetadata propertyMethodMetadata = entityMetadata.getIndexedProperty().getPropertyMethodMetadata();
        PropertyMetadata datastoreMetadata = (PropertyMetadata)propertyMethodMetadata.getDatastoreMetadata();
        String propertyName = datastoreMetadata.getName();
        Object datastoreValue = this.xoSession.toDatastore(value);
        final ResourceIterator iterator = this.graphDatabaseService.findNodes(label, propertyName, datastoreValue);
        return this.xoSession.toResult((ResultIterator)new ResultIterator<Node>(){

            public boolean hasNext() {
                return iterator.hasNext();
            }

            public Node next() {
                return (Node)iterator.next();
            }

            public void close() {
                iterator.close();
            }
        });
    }
}

