/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.internal.dragons;

public class FeatureToggles {
    public static boolean flag(Class<?> location, String name, boolean defaultValue) {
        return FeatureToggles.booleanProperty(FeatureToggles.name(location, name), defaultValue);
    }

    public static boolean packageFlag(Class<?> location, String name, boolean defaultValue) {
        return FeatureToggles.booleanProperty(FeatureToggles.name(location.getPackage(), name), defaultValue);
    }

    public static long getLong(Class<?> location, String name, long defaultValue) {
        return Long.getLong(FeatureToggles.name(location, name), defaultValue);
    }

    public static int getInteger(Class<?> location, String name, int defaultValue) {
        return Integer.getInteger(FeatureToggles.name(location, name), defaultValue);
    }

    public static <E extends Enum<E>> E flag(Class<?> location, String name, E defaultValue) {
        return FeatureToggles.enumProperty(defaultValue.getDeclaringClass(), FeatureToggles.name(location, name), defaultValue);
    }

    public static String toggle(Class<?> location, String name, boolean value) {
        return FeatureToggles.toggle(FeatureToggles.name(location, name), Boolean.toString(value));
    }

    public static String toggle(Class<?> location, String name, long value) {
        return FeatureToggles.toggle(FeatureToggles.name(location, name), Long.toString(value));
    }

    public static String toggle(Class<?> location, String name, Enum<?> value) {
        return FeatureToggles.toggle(FeatureToggles.name(location, name), value.name());
    }

    private static String toggle(String key, String value) {
        return "-D" + key + "=" + value;
    }

    private FeatureToggles() {
    }

    private static String name(Class<?> location, String name) {
        return location.getCanonicalName() + "." + name;
    }

    private static String name(Package location, String name) {
        return location.getName() + "." + name;
    }

    private static boolean booleanProperty(String flag, boolean defaultValue) {
        return FeatureToggles.parseBoolean(System.getProperty(flag), defaultValue);
    }

    private static boolean parseBoolean(String value, boolean defaultValue) {
        return defaultValue ? !"false".equalsIgnoreCase(value) : "true".equalsIgnoreCase(value);
    }

    private static <E extends Enum<E>> E enumProperty(Class<E> enumClass, String name, E defaultValue) {
        try {
            return Enum.valueOf(enumClass, System.getProperty(name, defaultValue.name()));
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }
}

