/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphalgo.impl.centrality;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphalgo.CostAccumulator;
import org.neo4j.graphalgo.impl.shortestpath.SingleSourceShortestPath;
import org.neo4j.graphdb.Node;

public abstract class ShortestPathBasedCentrality<CentralityType, ShortestPathCostType> {
    protected SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath;
    protected CostAccumulator<CentralityType> centralityAccumulator;
    protected CentralityType zeroValue;
    protected Set<Node> nodeSet;
    protected boolean doneCalculation = false;
    protected Map<Node, CentralityType> centralities = null;

    public ShortestPathBasedCentrality(SingleSourceShortestPath<ShortestPathCostType> singleSourceShortestPath, CostAccumulator<CentralityType> centralityAccumulator, CentralityType zeroValue, Set<Node> nodeSet) {
        this.singleSourceShortestPath = singleSourceShortestPath;
        this.centralityAccumulator = centralityAccumulator;
        this.zeroValue = zeroValue;
        this.nodeSet = nodeSet;
        this.reset();
    }

    public void reset() {
        this.doneCalculation = false;
        this.centralities = new HashMap<Node, CentralityType>();
        for (Node node : this.nodeSet) {
            this.centralities.put(node, this.zeroValue);
        }
    }

    protected void addCentralityToNode(Node node, CentralityType value) {
        CentralityType centrality = this.centralities.get(node);
        if (centrality == null) {
            centrality = this.zeroValue;
        }
        this.centralities.put(node, this.centralityAccumulator.addCosts(centrality, value));
    }

    protected void setCentralityForNode(Node node, CentralityType value) {
        this.centralities.put(node, value);
    }

    public CentralityType getCentrality(Node node) {
        this.calculate();
        return this.centralities.get(node);
    }

    public void calculate() {
        if (this.doneCalculation) {
            return;
        }
        this.doneCalculation = true;
        for (Node startNode : this.nodeSet) {
            this.singleSourceShortestPath.reset();
            this.singleSourceShortestPath.setStartNode(startNode);
            this.processShortestPaths(startNode, this.singleSourceShortestPath);
        }
    }

    public void skipCalculation() {
        this.doneCalculation = true;
    }

    public boolean isCalculated() {
        return this.doneCalculation;
    }

    public abstract void processShortestPaths(Node var1, SingleSourceShortestPath<ShortestPathCostType> var2);
}

