/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.neo4jserver.impl;

import java.util.List;
import org.neo4j.server.modules.ServerModule;
import org.neo4j.server.web.WebServer;

class JQAServerModule
implements ServerModule {
    public static final String MOUNTPOINT_REST = "/jqa/rest";
    public static final String MOUNTPOINT_STATIC = "/jqa";
    public static final String CONTENT_STATIC = "jqa";
    private WebServer webServer;
    private List<String> jaxRsClassNames;

    JQAServerModule(WebServer webServer, List<String> jaxRsClassNames) {
        this.webServer = webServer;
        this.jaxRsClassNames = jaxRsClassNames;
    }

    public void start() {
        this.webServer.addStaticContent(CONTENT_STATIC, MOUNTPOINT_STATIC);
        this.webServer.addJAXRSClasses(this.jaxRsClassNames, MOUNTPOINT_REST, null);
    }

    public void stop() {
        this.webServer.removeJAXRSClasses(this.jaxRsClassNames, MOUNTPOINT_REST);
        this.webServer.removeStaticContent(CONTENT_STATIC, MOUNTPOINT_STATIC);
    }
}

