/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.rule.AggregationVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.CypherExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.Metric;
import com.buschmais.jqassistant.core.analysis.api.rule.MetricGroup;
import com.buschmais.jqassistant.core.analysis.api.rule.Report;
import com.buschmais.jqassistant.core.analysis.api.rule.RowCountVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSetBuilder;
import com.buschmais.jqassistant.core.analysis.api.rule.ScriptExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Template;
import com.buschmais.jqassistant.core.analysis.api.rule.TemplateExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Verification;
import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import com.buschmais.jqassistant.core.analysis.impl.XmlHelper;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.AggregationVerificationType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ConceptType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ConstraintType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ExecutableRuleType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.GroupType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.IncludedReferenceType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.JqassistantRules;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.MetricGroupType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.MetricType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ParameterDefinitionType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ParameterType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ParameterTypes;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.PropertyType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ReferenceType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ReferenceableType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ReportType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.RowCountVerificationType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ScriptType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.SeverityEnumType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.TemplateType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.VerificationType;
import com.buschmais.jqassistant.core.shared.xml.JAXBUnmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlRuleSetReader
implements RuleSetReader {
    public static final String RULES_SCHEMA_LOCATION = "/META-INF/xsd/jqassistant-rules-1.1.xsd";
    public static final Schema SCHEMA = XmlHelper.getSchema("/META-INF/xsd/jqassistant-rules-1.1.xsd");
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlRuleSetReader.class);
    private JAXBUnmarshaller<JqassistantRules> jaxbUnmarshaller;
    public static final RowCountVerification DEFAULT_VERIFICATION = new RowCountVerification();

    public XmlRuleSetReader() {
        HashMap<String, String> namespaceMappings = new HashMap<String, String>();
        namespaceMappings.put("http://www.buschmais.com/jqassistant/core/analysis/rules/schema/v1.0", "http://www.buschmais.com/jqassistant/core/analysis/rules/schema/v1.1");
        this.jaxbUnmarshaller = new JAXBUnmarshaller(JqassistantRules.class, SCHEMA, namespaceMappings);
    }

    @Override
    public void read(List<? extends RuleSource> sources, RuleSetBuilder ruleSetBuilder) throws RuleException {
        for (RuleSource ruleSource : sources) {
            if (!ruleSource.isType(RuleSource.Type.XML)) continue;
            List<JqassistantRules> rules = this.readXmlSource(ruleSource);
            this.convert(rules, ruleSource, ruleSetBuilder);
        }
    }

    private List<JqassistantRules> readXmlSource(RuleSource ruleSource) {
        ArrayList<JqassistantRules> rules = new ArrayList<JqassistantRules>();
        try (InputStream inputStream = ruleSource.getInputStream();){
            LOGGER.debug("Reading rules from '{}'.", (Object)ruleSource.getId());
            JqassistantRules jqassistantRules = (JqassistantRules)this.jaxbUnmarshaller.unmarshal(inputStream);
            rules.add(jqassistantRules);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read rules from '" + ruleSource.getId() + "'.", e);
        }
        return rules;
    }

    private void convert(List<JqassistantRules> rules, RuleSource ruleSource, RuleSetBuilder builder) throws RuleException {
        for (JqassistantRules rule : rules) {
            List<ReferenceableType> queryDefinitionOrConceptOrConstraint = rule.getTemplateOrConceptOrConstraint();
            for (ReferenceableType referenceableType : queryDefinitionOrConceptOrConstraint) {
                String id = referenceableType.getId();
                if (referenceableType instanceof TemplateType) {
                    Template template = this.createTemplate((TemplateType)referenceableType, ruleSource);
                    builder.addTemplate(template);
                    continue;
                }
                if (referenceableType instanceof ConceptType) {
                    Concept concept = this.createConcept(id, ruleSource, (ConceptType)referenceableType);
                    builder.addConcept(concept);
                    continue;
                }
                if (referenceableType instanceof ConstraintType) {
                    Constraint constraint = this.createConstraint(id, ruleSource, (ConstraintType)referenceableType);
                    builder.addConstraint(constraint);
                    continue;
                }
                if (referenceableType instanceof GroupType) {
                    Group group = this.createGroup(id, ruleSource, (GroupType)referenceableType);
                    builder.addGroup(group);
                    continue;
                }
                if (!(referenceableType instanceof MetricGroupType)) continue;
                MetricGroup metricGroup = this.createMetricGroup(id, ruleSource, (MetricGroupType)referenceableType);
                builder.addMetricGroup(metricGroup);
            }
        }
    }

    private Template createTemplate(TemplateType templateType, RuleSource ruleSource) throws RuleException {
        HashMap parameterTypes = new HashMap();
        for (ParameterDefinitionType parameterDefinitionType : templateType.getParameterDefinition()) {
            Class parameterType;
            switch (parameterDefinitionType.getType()) {
                case INT: {
                    parameterType = Integer.class;
                    break;
                }
                case STRING: {
                    parameterType = String.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter parameterDefinitionType " + (Object)((Object)parameterDefinitionType.getType()));
                }
            }
            parameterTypes.put(parameterDefinitionType.getName(), parameterType);
        }
        Executable executable = this.createExecutable(templateType);
        return (Template)((Template.Builder)((Template.Builder)((Template.Builder)((Template.Builder)Template.Builder.newTemplate().id(templateType.getId())).description(templateType.getDescription())).ruleSource(ruleSource)).executable(executable)).parameterTypes(parameterTypes).get();
    }

    private MetricGroup createMetricGroup(String id, RuleSource ruleSource, MetricGroupType referenceableType) {
        LinkedHashMap<String, Metric> metrics = new LinkedHashMap<String, Metric>();
        for (MetricType metricType : referenceableType.getMetric()) {
            String cypher = metricType.getCypher();
            String description = metricType.getDescription();
            Map<String, Class<?>> parameterTypes = this.getParameterTypes(metricType.getParameterDefinition());
            Set<String> requiresConcepts = this.getRequiredReferences(metricType.getRequiresConcept());
            Metric metric = (Metric)((Metric.Builder)((Metric.Builder)((Metric.Builder)((Metric.Builder)((Metric.Builder)Metric.Builder.newMetric().id(id)).description(description)).ruleSource(ruleSource)).executable(new CypherExecutable(cypher))).parameterTypes(parameterTypes).requiresConceptIds(requiresConcepts)).get();
            metrics.put(metricType.getId(), metric);
        }
        return (MetricGroup)((MetricGroup.Builder)((MetricGroup.Builder)((MetricGroup.Builder)MetricGroup.Builder.newMetricGroup().id(id)).description(referenceableType.getDescription())).ruleSource(ruleSource)).metrics(metrics).get();
    }

    private Group createGroup(String id, RuleSource ruleSource, GroupType referenceableType) throws RuleException {
        SeverityEnumType severityType = referenceableType.getSeverity();
        Severity severity = this.getSeverity(severityType, Group.DEFAULT_SEVERITY);
        Map<String, Severity> includeConcepts = this.getIncludedReferences(referenceableType.getIncludeConcept());
        Map<String, Severity> includeConstraints = this.getIncludedReferences(referenceableType.getIncludeConstraint());
        Map<String, Severity> includeGroups = this.getIncludedReferences(referenceableType.getIncludeGroup());
        return (Group)((Group.Builder)((Group.Builder)((Group.Builder)Group.Builder.newGroup().id(id)).severity(severity)).ruleSource(ruleSource)).conceptIds(includeConcepts).constraintIds(includeConstraints).groupIds(includeGroups).get();
    }

    private Concept createConcept(String id, RuleSource ruleSource, ConceptType referenceableType) throws RuleException {
        String description = referenceableType.getDescription();
        Executable executable = this.createExecutable(referenceableType);
        Map<String, Object> parameters = this.getParameterValues(referenceableType.getParameter());
        SeverityEnumType severityType = referenceableType.getSeverity();
        Severity severity = this.getSeverity(severityType, Concept.DEFAULT_SEVERITY);
        List<ReferenceType> requiresConcept = referenceableType.getRequiresConcept();
        Set<String> requiresConcepts = this.getRequiredReferences(requiresConcept);
        String deprecated = referenceableType.getDeprecated();
        Verification verification = this.getVerification(referenceableType.getVerify());
        Report report = this.getReport(referenceableType.getReport());
        return (Concept)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)Concept.Builder.newConcept().id(id)).description(description)).ruleSource(ruleSource)).severity(severity)).deprecation(deprecated)).executable(executable)).parameters(parameters)).requiresConceptIds(requiresConcepts)).verification(verification)).report(report)).get();
    }

    private Report getReport(ReportType reportType) {
        String type = null;
        String primaryColumn = null;
        Properties properties = new Properties();
        if (reportType != null) {
            type = reportType.getType();
            primaryColumn = reportType.getPrimaryColumn();
            for (PropertyType propertyType : reportType.getProperty()) {
                properties.setProperty(propertyType.getName(), propertyType.getValue());
            }
        }
        Report.Builder reportBuilder = Report.Builder.newInstance().primaryColumn(primaryColumn).properties(properties);
        if (type != null) {
            reportBuilder.selectTypes(type);
        }
        return reportBuilder.get();
    }

    private Constraint createConstraint(String id, RuleSource ruleSource, ConstraintType referenceableType) throws RuleException {
        Executable executable = this.createExecutable(referenceableType);
        String description = referenceableType.getDescription();
        Map<String, Object> parameters = this.getParameterValues(referenceableType.getParameter());
        SeverityEnumType severityType = referenceableType.getSeverity();
        Severity severity = this.getSeverity(severityType, Constraint.DEFAULT_SEVERITY);
        List<ReferenceType> requiresConcept = referenceableType.getRequiresConcept();
        Set<String> requiresConcepts = this.getRequiredReferences(requiresConcept);
        String deprecated = referenceableType.getDeprecated();
        Verification verification = this.getVerification(referenceableType.getVerify());
        Report report = this.getReport(referenceableType.getReport());
        return (Constraint)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)Constraint.Builder.newConstraint().id(id)).description(description)).ruleSource(ruleSource)).severity(severity)).deprecation(deprecated)).executable(executable)).parameters(parameters)).requiresConceptIds(requiresConcepts)).verification(verification)).report(report)).get();
    }

    private Executable createExecutable(ExecutableRuleType executableRuleType) throws RuleException {
        String cypher = executableRuleType.getCypher();
        ScriptType scriptType = executableRuleType.getScript();
        ReferenceType useTemplate = executableRuleType.getUseTemplate();
        if (cypher != null) {
            return new CypherExecutable(cypher);
        }
        if (scriptType != null) {
            return new ScriptExecutable(scriptType.getLanguage(), scriptType.getValue());
        }
        if (useTemplate != null) {
            return new TemplateExecutable(useTemplate.getRefId());
        }
        throw new RuleException("Cannot determine executable for " + executableRuleType.getId());
    }

    private Verification getVerification(VerificationType verificationType) throws RuleException {
        if (verificationType != null) {
            RowCountVerificationType rowCountVerificationType = verificationType.getRowCount();
            AggregationVerificationType aggregationVerificationType = verificationType.getAggregation();
            if (rowCountVerificationType != null) {
                return new RowCountVerification();
            }
            if (aggregationVerificationType != null) {
                String column = aggregationVerificationType.getColumn();
                return new AggregationVerification(column);
            }
            throw new RuleException("Unsupported verification " + verificationType);
        }
        return DEFAULT_VERIFICATION;
    }

    private Set<String> getRequiredReferences(List<? extends ReferenceType> referenceTypes) {
        HashSet<String> references = new HashSet<String>();
        for (ReferenceType referenceType : referenceTypes) {
            references.add(referenceType.getRefId());
        }
        return references;
    }

    private Map<String, Severity> getIncludedReferences(List<IncludedReferenceType> referenceType) throws RuleException {
        HashMap<String, Severity> references = new HashMap<String, Severity>();
        for (IncludedReferenceType includedReferenceType : referenceType) {
            Severity severity = this.getSeverity(includedReferenceType.getSeverity(), null);
            references.put(includedReferenceType.getRefId(), severity);
        }
        return references;
    }

    private Map<String, Class<?>> getParameterTypes(List<ParameterDefinitionType> parameterDefinitionTypes) {
        HashMap parameters = new HashMap();
        for (ParameterDefinitionType parameterDefinitionType : parameterDefinitionTypes) {
            Class type;
            switch (parameterDefinitionType.getType()) {
                case INT: {
                    type = Integer.class;
                    break;
                }
                case STRING: {
                    type = String.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported parameter definition type" + parameterDefinitionType);
                }
            }
            parameters.put(parameterDefinitionType.getName(), type);
        }
        return parameters;
    }

    private Severity getSeverity(SeverityEnumType severityType, Severity defaultSeverity) throws RuleException {
        return severityType == null ? defaultSeverity : Severity.fromValue(severityType.value());
    }

    private Map<String, Object> getParameterValues(List<ParameterType> parameter) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (ParameterType parameterType : parameter) {
            Object value = this.getParameterValue(parameterType.getType(), parameterType.getValue());
            parameters.put(parameterType.getName(), value);
        }
        return parameters;
    }

    private Object getParameterValue(ParameterTypes type, String stringValue) {
        Object value;
        switch (type) {
            case INT: {
                value = Integer.valueOf(stringValue);
                break;
            }
            case STRING: {
                value = stringValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported parameter types: " + (Object)((Object)type));
            }
        }
        return value;
    }
}

