/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.RuleSetWriter;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.CypherExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.ScriptExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.TemplateExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.visitor.CollectRulesVisitor;
import com.buschmais.jqassistant.core.analysis.impl.CDataXMLStreamWriter;
import com.buschmais.jqassistant.core.analysis.impl.RuleExecutor;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ConceptType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ConstraintType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ExecutableRuleType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.GroupType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.IncludedReferenceType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.JqassistantRules;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ObjectFactory;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ReferenceType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.ScriptType;
import com.buschmais.jqassistant.core.analysis.rules.schema.v1.SeverityEnumType;
import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class RuleSetWriterImpl
implements RuleSetWriter {
    private JAXBContext jaxbContext;

    public RuleSetWriterImpl() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Cannot create JAXB context.", e);
        }
    }

    @Override
    public void write(RuleSet ruleSet, Writer writer) throws RuleException {
        CollectRulesVisitor visitor = new CollectRulesVisitor();
        RuleSelection ruleSelection = RuleSelection.Builder.newInstance().addGroupIds(ruleSet.getGroupsBucket().getIds()).addConstraintIds(ruleSet.getConstraintBucket().getIds()).addConceptIds(ruleSet.getConceptBucket().getIds()).get();
        try {
            new RuleExecutor(visitor).execute(ruleSet, ruleSelection);
        }
        catch (AnalysisException e) {
            throw new RuleException("Cannot create rule set", e);
        }
        JqassistantRules rules = new JqassistantRules();
        this.writeGroups(visitor.getGroups(), rules);
        this.writeConcepts(visitor.getConcepts().keySet(), rules);
        this.writeConstraints(visitor.getConstraints().keySet(), rules);
        this.marshal(writer, rules);
    }

    private void marshal(Writer writer, JqassistantRules rules) {
        XMLOutputFactory xof = XMLOutputFactory.newInstance();
        XMLStreamWriter streamWriter = null;
        try {
            streamWriter = xof.createXMLStreamWriter(writer);
        }
        catch (XMLStreamException e) {
            e.printStackTrace();
        }
        IndentingXMLStreamWriter indentingStreamWriter = new IndentingXMLStreamWriter((XMLStreamWriter)new CDataXMLStreamWriter(streamWriter));
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.marshal((Object)rules, (XMLStreamWriter)indentingStreamWriter);
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Cannot write rules to " + writer, e);
        }
    }

    private void writeGroups(Collection<Group> groups, JqassistantRules rules) {
        for (Group group : groups) {
            GroupType groupType = new GroupType();
            groupType.setId(group.getId());
            for (Map.Entry<String, Severity> groupEntry : group.getGroups().entrySet()) {
                IncludedReferenceType groupReferenceType = new IncludedReferenceType();
                groupReferenceType.setRefId(groupEntry.getKey());
                groupType.setSeverity(this.getSeverity(groupEntry.getValue(), Group.DEFAULT_SEVERITY));
                groupType.getIncludeGroup().add(groupReferenceType);
            }
            for (Map.Entry<String, Severity> conceptEntry : group.getConcepts().entrySet()) {
                IncludedReferenceType conceptReferenceType = new IncludedReferenceType();
                conceptReferenceType.setRefId(conceptEntry.getKey());
                conceptReferenceType.setSeverity(this.getSeverity(conceptEntry.getValue(), Concept.DEFAULT_SEVERITY));
                groupType.getIncludeConcept().add(conceptReferenceType);
            }
            for (Map.Entry<String, Severity> constraintEntry : group.getConstraints().entrySet()) {
                IncludedReferenceType constraintReferenceType = new IncludedReferenceType();
                constraintReferenceType.setRefId(constraintEntry.getKey());
                constraintReferenceType.setSeverity(this.getSeverity(constraintEntry.getValue(), Constraint.DEFAULT_SEVERITY));
                groupType.getIncludeConstraint().add(constraintReferenceType);
            }
            rules.getTemplateOrConceptOrConstraint().add(groupType);
        }
    }

    private void writeConcepts(Collection<Concept> concepts, JqassistantRules rules) throws RuleException {
        for (Concept concept : concepts) {
            ConceptType conceptType = new ConceptType();
            conceptType.setId(concept.getId());
            conceptType.setDescription(concept.getDescription());
            conceptType.setSeverity(this.getSeverity(concept.getSeverity(), Concept.DEFAULT_SEVERITY));
            this.writeExecutable(conceptType, concept);
            for (String requiresConceptId : concept.getRequiresConcepts()) {
                ReferenceType conceptReferenceType = new ReferenceType();
                conceptReferenceType.setRefId(requiresConceptId);
                conceptType.getRequiresConcept().add(conceptReferenceType);
            }
            rules.getTemplateOrConceptOrConstraint().add(conceptType);
        }
    }

    private void writeConstraints(Collection<Constraint> constraints, JqassistantRules rules) throws RuleException {
        for (Constraint constraint : constraints) {
            ConstraintType constraintType = new ConstraintType();
            constraintType.setId(constraint.getId());
            constraintType.setDescription(constraint.getDescription());
            constraintType.setSeverity(this.getSeverity(constraint.getSeverity(), Constraint.DEFAULT_SEVERITY));
            this.writeExecutable(constraintType, constraint);
            for (String requiresConceptId : constraint.getRequiresConcepts()) {
                ReferenceType conceptReferenceType = new ReferenceType();
                conceptReferenceType.setRefId(requiresConceptId);
                constraintType.getRequiresConcept().add(conceptReferenceType);
            }
            rules.getTemplateOrConceptOrConstraint().add(constraintType);
        }
    }

    private void writeExecutable(ExecutableRuleType executableRuleType, ExecutableRule executableRule) throws RuleException {
        Executable executable = executableRule.getExecutable();
        if (executable instanceof CypherExecutable) {
            CypherExecutable cypherExecutable = (CypherExecutable)executable;
            executableRuleType.setCypher(cypherExecutable.getStatement());
        } else if (executable instanceof ScriptExecutable) {
            ScriptExecutable scriptExecutable = (ScriptExecutable)executable;
            ScriptType scriptType = new ScriptType();
            scriptType.setLanguage(scriptExecutable.getLanguage());
            scriptType.setValue(scriptExecutable.getSource());
            executableRuleType.setScript(scriptType);
        } else if (executable instanceof TemplateExecutable) {
            ReferenceType template = new ReferenceType();
            template.setRefId(((TemplateExecutable)executable).getTemplateId());
            executableRuleType.setUseTemplate(template);
        } else {
            throw new RuleException("Unsupport executable type " + executable);
        }
    }

    private SeverityEnumType getSeverity(Severity severity, Severity defaultSeverity) {
        if (severity == null) {
            severity = defaultSeverity;
        }
        return SeverityEnumType.fromValue(severity.getValue());
    }
}

