/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.NoConceptException;
import com.buschmais.jqassistant.core.analysis.api.rule.NoGroupException;
import com.buschmais.jqassistant.core.analysis.api.rule.NoRuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.NoTemplateException;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.SeverityRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Template;
import com.buschmais.jqassistant.core.analysis.impl.RuleVisitor;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RuleExecutor {
    private Set<Concept> executedConcepts = new HashSet<Concept>();
    private Set<Constraint> executedConstraints = new HashSet<Constraint>();
    private Set<Group> executedGroups = new HashSet<Group>();
    private RuleVisitor ruleVisitor;

    public RuleExecutor(RuleVisitor ruleVisitor) {
        this.ruleVisitor = ruleVisitor;
    }

    public void execute(RuleSet ruleSet, RuleSelection ruleSelection) throws AnalysisException {
        for (String conceptId : ruleSelection.getConceptIds()) {
            Concept concept = this.resolveConcept(ruleSet, conceptId);
            this.applyConcept(ruleSet, concept, concept.getSeverity());
        }
        for (String constraintId : ruleSelection.getConstraintIds()) {
            Constraint constraint = this.resolveConstraint(ruleSet, constraintId);
            this.validateConstraint(ruleSet, constraint, constraint.getSeverity());
        }
        for (String groupId : ruleSelection.getGroupIds()) {
            Group group = this.resolveGroup(ruleSet, groupId);
            this.executeGroup(ruleSet, group, group.getSeverity());
        }
    }

    private void executeGroup(RuleSet ruleSet, Group group, Severity severity) throws AnalysisException {
        if (!this.executedGroups.contains(group)) {
            this.ruleVisitor.beforeGroup(group, this.getEffectiveSeverity(group, severity, severity));
            for (Map.Entry<String, Severity> entry : group.getGroups().entrySet()) {
                String string = entry.getKey();
                Group includedGroup = this.resolveGroup(ruleSet, string);
                this.executeGroup(ruleSet, includedGroup, this.getEffectiveSeverity(includedGroup, severity, entry.getValue()));
            }
            Map<String, Severity> concepts = group.getConcepts();
            for (Map.Entry<String, Severity> entry : concepts.entrySet()) {
                String conceptId = entry.getKey();
                Concept concept = this.resolveConcept(ruleSet, conceptId);
                this.applyConcept(ruleSet, concept, this.getEffectiveSeverity(concept, severity, entry.getValue()));
            }
            Map<String, Severity> map = group.getConstraints();
            for (Map.Entry<String, Severity> constraintEntry : map.entrySet()) {
                String constraintId = constraintEntry.getKey();
                Constraint constraint = this.resolveConstraint(ruleSet, constraintId);
                this.validateConstraint(ruleSet, constraint, this.getEffectiveSeverity(constraint, severity, constraintEntry.getValue()));
            }
            this.executedGroups.add(group);
            this.ruleVisitor.afterGroup(group);
        }
    }

    private Severity getEffectiveSeverity(SeverityRule rule, Severity parentSeverity, Severity ruleSeverity) {
        Severity managedSeverity = ruleSeverity != null ? ruleSeverity : parentSeverity;
        return managedSeverity != null ? managedSeverity : rule.getSeverity();
    }

    private void validateConstraint(RuleSet ruleSet, Constraint constraint, Severity severity) throws AnalysisException {
        if (!this.executedConstraints.contains(constraint)) {
            for (String requiredConceptId : constraint.getRequiresConcepts()) {
                Concept requiredConcept = this.resolveConcept(ruleSet, requiredConceptId);
                this.applyConcept(ruleSet, requiredConcept, requiredConcept.getSeverity());
            }
            this.ruleVisitor.visitConstraint(constraint, severity);
            this.executedConstraints.add(constraint);
        }
    }

    private void applyConcept(RuleSet ruleSet, Concept concept, Severity severity) throws AnalysisException {
        if (!this.executedConcepts.contains(concept)) {
            for (String requiredConceptId : concept.getRequiresConcepts()) {
                Concept requiredConcept = this.resolveConcept(ruleSet, requiredConceptId);
                this.applyConcept(ruleSet, requiredConcept, requiredConcept.getSeverity());
            }
            this.ruleVisitor.visitConcept(concept, severity);
            this.executedConcepts.add(concept);
        }
    }

    public Template resolveTemplate(RuleSet ruleSet, String queryTemplateId) throws AnalysisException {
        try {
            return (Template)ruleSet.getTemplateBucket().getById(queryTemplateId);
        }
        catch (NoTemplateException e) {
            throw new AnalysisException("Query template '" + queryTemplateId + " is not defined.", e);
        }
    }

    public Concept resolveConcept(RuleSet ruleSet, String requiredConceptId) throws AnalysisException {
        try {
            return (Concept)ruleSet.getConceptBucket().getById(requiredConceptId);
        }
        catch (NoConceptException e) {
            throw new AnalysisException("Concept '" + requiredConceptId + "' is not defined.");
        }
    }

    public Constraint resolveConstraint(RuleSet ruleSet, String constraintId) throws AnalysisException {
        try {
            return (Constraint)ruleSet.getConstraintBucket().getById(constraintId);
        }
        catch (NoRuleException e) {
            throw new AnalysisException("Constraint '" + constraintId + "' not found.");
        }
    }

    public Group resolveGroup(RuleSet ruleSet, String groupId) throws AnalysisException {
        try {
            return (Group)ruleSet.getGroupsBucket().getById(groupId);
        }
        catch (NoGroupException e) {
            throw new AnalysisException("Group '" + groupId + "' is not defined.", e);
        }
    }
}

