/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.rule.AggregationVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.CypherExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.Report;
import com.buschmais.jqassistant.core.analysis.api.rule.RowCountVerification;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSetBuilder;
import com.buschmais.jqassistant.core.analysis.api.rule.ScriptExecutable;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import com.buschmais.jqassistant.core.analysis.api.rule.Verification;
import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.ast.ContentPart;
import org.asciidoctor.ast.StructuredDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsciiDocRuleSetReader
implements RuleSetReader {
    private static final Set<String> EXECUTABLE_RULE_TYPES = new HashSet<String>(Arrays.asList("concept", "constraint"));
    private static final Logger LOGGER = LoggerFactory.getLogger(AsciiDocRuleSetReader.class);
    private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("(.*?)(\\((.*)\\))?");
    public static final String CONCEPT = "concept";
    public static final String CONSTRAINT = "constraint";
    public static final String GROUP = "group";
    public static final String INCLUDES_GROUPS = "includesGroups";
    public static final String INCLUDES_CONCEPTS = "includesConcepts";
    public static final String INCLUDES_CONSTRAINTS = "includesConstraints";
    public static final String SEVERITY = "severity";
    public static final String DEPENDS = "depends";
    public static final String REQUIRES_CONCEPTS = "requiresConcepts";
    public static final String REPORT_TYPE = "reportType";
    public static final String PRIMARY_REPORT_COLUM = "primaryReportColumn";
    public static final String REPORT_PROPERTIES = "reportProperties";
    public static final String VERIFY = "verify";
    public static final String AGGREGATION = "aggregation";
    public static final String AGGREGATION_COLUMN = "aggregationColumn";
    public static final String TITLE = "title";
    public static final String LISTING = "listing";
    public static final String SOURCE = "source";
    public static final String LANGUAGE = "language";
    public static final String CYPHER = "cypher";
    private Asciidoctor cachedAsciidoctor = null;

    @Override
    public void read(List<? extends RuleSource> sources, RuleSetBuilder ruleSetBuilder) throws RuleException {
        for (RuleSource ruleSource : sources) {
            if (!ruleSource.isType(RuleSource.Type.AsciiDoc)) continue;
            this.readDocument(ruleSource, ruleSetBuilder);
        }
    }

    private void readDocument(RuleSource source, RuleSetBuilder builder) throws RuleException {
        InputStream stream;
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("STRUCTURE_MAX_LEVEL", 10);
        try {
            stream = source.getInputStream();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Cannot read rules from '" + source.getId() + "'.", e);
        }
        StructuredDocument doc = this.getAsciidoctor().readDocumentStructure((Reader)new InputStreamReader(stream), parameters);
        this.extractExecutableRules(source, doc, builder);
        this.extractGroups(source, doc, builder);
    }

    private Asciidoctor getAsciidoctor() {
        if (this.cachedAsciidoctor == null) {
            LOGGER.debug("Creating Asciidoctor instance.");
            this.cachedAsciidoctor = Asciidoctor.Factory.create();
        }
        return this.cachedAsciidoctor;
    }

    private void extractExecutableRules(RuleSource ruleSource, StructuredDocument doc, RuleSetBuilder builder) throws RuleException {
        for (ContentPart part : AsciiDocRuleSetReader.findExecutableRules(doc.getParts())) {
            Severity severity;
            Object aggregationColumn;
            Map attributes = part.getAttributes();
            String id = part.getId();
            String description = "";
            Object title = attributes.get(TITLE);
            if (title != null) {
                description = title.toString();
            } else {
                LOGGER.info("Description of rule is missing: Using empty text for description (source='{}', id='{}').", (Object)ruleSource.getId(), (Object)id);
            }
            HashSet<String> requiresConcepts = new HashSet<String>(this.getDependencies(attributes, REQUIRES_CONCEPTS).keySet());
            Set<String> depends = this.getDependencies(attributes, DEPENDS).keySet();
            if (!depends.isEmpty()) {
                LOGGER.info("Using 'depends' to reference required concepts is deprecated, please use 'requiresConcepts' (source='{}', id='{}'}.", (Object)ruleSource.getId(), (Object)id);
                requiresConcepts.addAll(depends);
            }
            Object language = part.getAttributes().get(LANGUAGE);
            String source = this.unescapeHtml(part.getContent());
            Executable executable = CYPHER.equals(language) ? new CypherExecutable(source) : new ScriptExecutable(language.toString(), source);
            boolean aggregation = AGGREGATION.equals(part.getAttributes().get(VERIFY));
            Verification verification = aggregation ? new AggregationVerification((aggregationColumn = part.getAttributes().get(AGGREGATION_COLUMN)) != null ? aggregationColumn.toString() : null) : new RowCountVerification();
            Report report = this.getReport(part);
            if (CONCEPT.equals(part.getRole())) {
                severity = this.getSeverity(part, Concept.DEFAULT_SEVERITY);
                Concept concept = (Concept)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)((Concept.Builder)Concept.Builder.newConcept().id(id)).description(description)).severity(severity)).executable(executable)).requiresConceptIds(requiresConcepts)).verification(verification)).report(report)).get();
                builder.addConcept(concept);
                continue;
            }
            if (!CONSTRAINT.equals(part.getRole())) continue;
            severity = this.getSeverity(part, Constraint.DEFAULT_SEVERITY);
            Constraint constraint = (Constraint)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)((Constraint.Builder)Constraint.Builder.newConstraint().id(id)).description(description)).severity(severity)).executable(executable)).requiresConceptIds(requiresConcepts)).verification(verification)).report(report)).get();
            builder.addConstraint(constraint);
        }
    }

    private void extractGroups(RuleSource ruleSource, StructuredDocument doc, RuleSetBuilder ruleSetBuilder) throws RuleException {
        for (ContentPart contentPart : AsciiDocRuleSetReader.findGroups(doc.getParts())) {
            Map attributes = contentPart.getAttributes();
            Map<String, Severity> constraints = this.getDependencies(attributes, INCLUDES_CONSTRAINTS);
            Map<String, Severity> concepts = this.getDependencies(attributes, INCLUDES_CONCEPTS);
            Map<String, Severity> groups = this.getDependencies(attributes, INCLUDES_GROUPS);
            Severity severity = this.getSeverity(contentPart, null);
            Group group = (Group)((Group.Builder)((Group.Builder)((Group.Builder)((Group.Builder)Group.Builder.newGroup().id(contentPart.getId())).description(contentPart.getTitle())).severity(severity)).ruleSource(ruleSource)).conceptIds(concepts).constraintIds(constraints).groupIds(groups).get();
            ruleSetBuilder.addGroup(group);
        }
    }

    private Map<String, Severity> getDependencies(Map<String, Object> attributes, String attributeName) throws RuleException {
        String attribute = (String)attributes.get(attributeName);
        HashSet<String> dependencies = new HashSet<String>();
        if (attribute != null && !attribute.trim().isEmpty()) {
            dependencies.addAll(Arrays.asList(attribute.split("\\s*,\\s*")));
        }
        HashMap<String, Severity> rules = new HashMap<String, Severity>();
        for (String dependency : dependencies) {
            Matcher matcher = DEPENDENCY_PATTERN.matcher(dependency);
            if (!matcher.matches()) continue;
            String id = matcher.group(1);
            String severityValue = matcher.group(3);
            Severity severity = severityValue != null ? Severity.fromValue(severityValue.toLowerCase()) : null;
            rules.put(id, severity);
        }
        return rules;
    }

    private Severity getSeverity(ContentPart part, Severity defaultSeverity) throws RuleException {
        Object severity = part.getAttributes().get(SEVERITY);
        if (severity == null) {
            return defaultSeverity;
        }
        Severity value = Severity.fromValue(severity.toString().toLowerCase());
        return value != null ? value : defaultSeverity;
    }

    private String unescapeHtml(String content) {
        return content.replace("&lt;", "<").replace("&gt;", ">");
    }

    private static Collection<ContentPart> findExecutableRules(Collection<ContentPart> parts) {
        LinkedHashSet<ContentPart> result = new LinkedHashSet<ContentPart>();
        if (parts != null) {
            for (ContentPart part : parts) {
                if (LISTING.equals(part.getContext()) && SOURCE.equals(part.getStyle()) && EXECUTABLE_RULE_TYPES.contains(part.getRole())) {
                    result.add(part);
                }
                result.addAll(AsciiDocRuleSetReader.findExecutableRules(part.getParts()));
            }
        }
        return result;
    }

    private static Collection<ContentPart> findGroups(Collection<ContentPart> parts) {
        LinkedHashSet<ContentPart> result = new LinkedHashSet<ContentPart>();
        if (parts != null) {
            for (ContentPart part : parts) {
                if (GROUP.equals(part.getRole())) {
                    result.add(part);
                }
                result.addAll(AsciiDocRuleSetReader.findGroups(part.getParts()));
            }
        }
        return result;
    }

    private Report getReport(ContentPart part) {
        Object primaryReportColum = part.getAttributes().get(PRIMARY_REPORT_COLUM);
        Object reportType = part.getAttributes().get(REPORT_TYPE);
        Properties reportProperties = this.parseProperties(part, REPORT_PROPERTIES);
        Report.Builder reportBuilder = Report.Builder.newInstance();
        if (reportType != null) {
            reportBuilder.selectTypes(reportType.toString());
        }
        if (primaryReportColum != null) {
            reportBuilder.primaryColumn(primaryReportColum.toString());
        }
        return reportBuilder.properties(reportProperties).get();
    }

    private Properties parseProperties(ContentPart part, String attributeName) {
        Properties properties = new Properties();
        Object attribute = part.getAttributes().get(attributeName);
        if (attribute == null) {
            return properties;
        }
        Scanner propertiesScanner = new Scanner(attribute.toString());
        propertiesScanner.useDelimiter(";");
        while (propertiesScanner.hasNext()) {
            String next = propertiesScanner.next().trim();
            if (next.length() <= 0) continue;
            Scanner propertyScanner = new Scanner(next);
            propertyScanner.useDelimiter("=");
            String key = propertyScanner.next().trim();
            String value = propertyScanner.next().trim();
            properties.setProperty(key, value);
        }
        return properties;
    }
}

