/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.impl;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListener;
import com.buschmais.jqassistant.core.analysis.api.AnalysisListenerException;
import com.buschmais.jqassistant.core.analysis.api.Analyzer;
import com.buschmais.jqassistant.core.analysis.api.AnalyzerConfiguration;
import com.buschmais.jqassistant.core.analysis.api.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.impl.AnalyzerVisitor;
import com.buschmais.jqassistant.core.analysis.impl.RuleExecutor;
import com.buschmais.jqassistant.core.store.api.Store;
import org.slf4j.Logger;

public class AnalyzerImpl
implements Analyzer {
    private AnalyzerConfiguration configuration;
    private Store store;
    private AnalysisListener reportWriter;
    private Logger logger;

    public AnalyzerImpl(AnalyzerConfiguration configuration, Store store, AnalysisListener reportWriter, Logger log) {
        this.configuration = configuration;
        this.store = store;
        this.reportWriter = reportWriter;
        this.logger = log;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(RuleSet ruleSet, RuleSelection ruleSelection) throws AnalysisException {
        try {
            this.reportWriter.begin();
            try {
                AnalyzerVisitor visitor = new AnalyzerVisitor(ruleSet, this.configuration.isExecuteAppliedConcepts(), this.store, this.reportWriter, this.logger);
                RuleExecutor executor = new RuleExecutor(visitor);
                executor.execute(ruleSet, ruleSelection);
            }
            finally {
                this.reportWriter.end();
            }
        }
        catch (AnalysisListenerException e) {
            throw new AnalysisException("Cannot write report.", e);
        }
    }
}

