/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule.visitor;

import com.buschmais.jqassistant.core.analysis.api.AnalysisException;
import com.buschmais.jqassistant.core.analysis.api.rule.AbstractRuleVisitor;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.Rule;
import com.buschmais.jqassistant.core.analysis.api.rule.Severity;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CollectRulesVisitor
extends AbstractRuleVisitor {
    private static final Comparator<Rule> RULE_COMPARATOR = new Comparator<Rule>(){

        @Override
        public int compare(Rule o1, Rule o2) {
            return o1.getId().compareTo(o2.getId());
        }
    };
    private Map<Concept, Severity> concepts = new TreeMap<Rule, Severity>(RULE_COMPARATOR);
    private Map<Constraint, Severity> constraints = new TreeMap<Rule, Severity>(RULE_COMPARATOR);
    private Set<Group> groups = new TreeSet<Rule>(RULE_COMPARATOR);
    private Set<String> missingConcepts = new TreeSet<String>();
    private Set<String> missingConstraints = new TreeSet<String>();
    private Set<String> missingGroups = new TreeSet<String>();

    @Override
    public void visitConcept(Concept concept, Severity effectiveSeverity) throws AnalysisException {
        this.concepts.put(concept, effectiveSeverity);
    }

    @Override
    public void visitConstraint(Constraint constraint, Severity effectiveSeverity) throws AnalysisException {
        this.constraints.put(constraint, effectiveSeverity);
    }

    @Override
    public void beforeGroup(Group group, Severity effectiveSeverity) throws AnalysisException {
        this.groups.add(group);
    }

    public Map<Concept, Severity> getConcepts() {
        return this.concepts;
    }

    public Map<Constraint, Severity> getConstraints() {
        return this.constraints;
    }

    public Set<Group> getGroups() {
        return this.groups;
    }

    public Set<String> getMissingConcepts() {
        return this.missingConcepts;
    }

    public Set<String> getMissingConstraints() {
        return this.missingConstraints;
    }

    public Set<String> getMissingGroups() {
        return this.missingGroups;
    }
}

