/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule.source;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public abstract class RuleSource {
    public boolean isType(Type type) {
        Type thisType = this.getType();
        if (thisType == null) {
            throw new IllegalArgumentException("No matching type found for " + this.getId() + " available types " + Arrays.toString((Object[])Type.values()));
        }
        return type.equals((Object)thisType);
    }

    protected Type selectTypeById() {
        String path = this.getId();
        for (Type type : Type.values()) {
            if (!type.matches(path)) continue;
            return type;
        }
        return null;
    }

    protected abstract Type getType();

    public abstract String getId();

    public abstract InputStream getInputStream() throws IOException;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuleSource that = (RuleSource)o;
        return this.getId().equals(that.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getId();
    }

    public static enum Type {
        AsciiDoc("adoc"),
        XML("xml");

        String ext;

        private Type(String ext) {
            this.ext = ext;
        }

        public boolean matches(File file) {
            return this.matches(file.getName());
        }

        boolean matches(String path) {
            return path.toLowerCase().endsWith("." + this.ext);
        }
    }
}

