/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule.source;

import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import java.io.IOException;
import java.io.InputStream;

public class ClasspathRuleSource
extends RuleSource {
    private ClassLoader classLoader;
    private String resource;

    public ClasspathRuleSource(ClassLoader classLoader, String resource) {
        this.classLoader = classLoader;
        this.resource = resource;
    }

    @Override
    protected RuleSource.Type getType() {
        return this.selectTypeById();
    }

    @Override
    public String getId() {
        return this.resource;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        ClassLoader currentClassloader = this.classLoader != null ? this.classLoader : Thread.currentThread().getContextClassLoader();
        return currentClassloader.getResourceAsStream(this.resource);
    }
}

