/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule;

import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.ConceptBucket;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.ConstraintBucket;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.analysis.api.rule.GroupsBucket;
import com.buschmais.jqassistant.core.analysis.api.rule.MetricGroup;
import com.buschmais.jqassistant.core.analysis.api.rule.MetricGroupsBucket;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleHandlingException;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.Template;
import com.buschmais.jqassistant.core.analysis.api.rule.TemplateBucket;

public class RuleSetBuilder {
    private DefaultRuleSet ruleSet = new DefaultRuleSet();

    private RuleSetBuilder() {
    }

    public static RuleSetBuilder newInstance() {
        return new RuleSetBuilder();
    }

    public RuleSetBuilder addTemplate(Template template) throws RuleException {
        this.ruleSet.templateBucket.add(template);
        return this;
    }

    public RuleSetBuilder addConcept(Concept concept) throws RuleHandlingException {
        this.ruleSet.conceptBucket.add(concept);
        return this;
    }

    public RuleSetBuilder addConstraint(Constraint constraint) throws RuleException {
        this.ruleSet.constraintBucket.add(constraint);
        return this;
    }

    public RuleSetBuilder addGroup(Group group) throws RuleException {
        this.ruleSet.groupsBucket.add(group);
        return this;
    }

    public RuleSetBuilder addMetricGroup(MetricGroup metricGroup) throws RuleException {
        this.ruleSet.getMetricGroupsBucket().add(metricGroup);
        return this;
    }

    public RuleSet getRuleSet() {
        return this.ruleSet;
    }

    private static class DefaultRuleSet
    implements RuleSet {
        private ConceptBucket conceptBucket = new ConceptBucket();
        private ConstraintBucket constraintBucket = new ConstraintBucket();
        private TemplateBucket templateBucket = new TemplateBucket();
        private GroupsBucket groupsBucket = new GroupsBucket();
        private MetricGroupsBucket metricGroupsBucket = new MetricGroupsBucket();

        private DefaultRuleSet() {
        }

        @Override
        public TemplateBucket getTemplateBucket() {
            return this.templateBucket;
        }

        @Override
        public ConceptBucket getConceptBucket() {
            return this.conceptBucket;
        }

        @Override
        public ConstraintBucket getConstraintBucket() {
            return this.constraintBucket;
        }

        @Override
        public GroupsBucket getGroupsBucket() {
            return this.groupsBucket;
        }

        @Override
        public MetricGroupsBucket getMetricGroupsBucket() {
            return this.metricGroupsBucket;
        }

        public String toString() {
            return "RuleSet{groups=" + this.groupsBucket.size() + ", constraints=" + this.constraintBucket.size() + ", rules=" + this.conceptBucket.size() + ", metric groups=" + this.metricGroupsBucket.size() + "}";
        }
    }
}

