/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule;

import java.util.Map;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;

public class Report {
    private Set<String> selectedTypes = null;
    private String primaryColumn = null;
    private Properties properties = new Properties();

    private Report() {
    }

    public Set<String> getSelectedTypes() {
        return this.selectedTypes;
    }

    public String getPrimaryColumn() {
        return this.primaryColumn;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public static class Builder {
        private Report report = new Report();

        public static Builder newInstance() {
            return new Builder();
        }

        public Builder selectTypes(String reportTypes) {
            if (this.report.selectedTypes == null) {
                this.report.selectedTypes = new TreeSet();
            }
            Scanner scanner = new Scanner(reportTypes).useDelimiter(",");
            while (scanner.hasNext()) {
                String reportType = scanner.next();
                this.report.selectedTypes.add(reportType.trim());
            }
            return this;
        }

        public Builder property(String key, String value) {
            this.report.properties.setProperty(key, value);
            return this;
        }

        public Builder primaryColumn(String primaryColumn) {
            this.report.primaryColumn = primaryColumn;
            return this;
        }

        public Builder properties(Properties properties) {
            this.report.properties.putAll((Map<?, ?>)properties);
            return this;
        }

        public Report get() {
            return this.report;
        }
    }
}

