/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule;

import com.buschmais.jqassistant.core.analysis.api.rule.AbstractRule;
import com.buschmais.jqassistant.core.analysis.api.rule.DuplicateRuleException;
import com.buschmais.jqassistant.core.analysis.api.rule.NoRuleException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;

public abstract class AbstractRuleBucket<T extends AbstractRule, NRE extends NoRuleException, DRE extends DuplicateRuleException> {
    TreeMap<String, T> rules = new TreeMap();

    public int size() {
        return this.rules.size();
    }

    protected void add(T rule) throws DRE {
        if (this.rules.containsKey(((AbstractRule)rule).getId())) {
            throw this.newDuplicateRuleException("The " + this.getRuleTypeName() + " " + ((AbstractRule)rule).getId() + " is already contained in this bucket");
        }
        this.rules.put(((AbstractRule)rule).getId(), rule);
    }

    protected abstract String getRuleTypeName();

    public Collection<T> getAll() {
        return Collections.unmodifiableCollection(this.rules.values());
    }

    protected abstract DRE newDuplicateRuleException(String var1);

    protected abstract NRE newNoRuleException(String var1);

    public Set<String> getIds() {
        return Collections.unmodifiableSet(this.rules.keySet());
    }

    public T getById(String id) throws NRE {
        AbstractRule rule = (AbstractRule)this.rules.get(id);
        if (null == rule) {
            throw this.newNoRuleException(id);
        }
        return (T)rule;
    }

    public <B extends AbstractRuleBucket<T, NRE, DRE>> void add(B bucket) throws DRE {
        String id = null;
        try {
            Iterator<String> iterator = bucket.getIds().iterator();
            while (iterator.hasNext()) {
                String conceptId;
                id = conceptId = iterator.next();
                B rule = null;
                rule = (B)bucket.getById(id);
                this.add(rule);
            }
        }
        catch (NoRuleException e) {
            throw new IllegalStateException("No rule of type " + this.getRuleTypeName() + " width  " + id + " not found in overhanded bucket. The bucket is in an inconsistent state.");
        }
    }
}

