/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule;

import com.buschmais.jqassistant.core.analysis.api.rule.Rule;
import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;

public abstract class AbstractRule
implements Rule {
    private String id;
    private String description;
    private RuleSource ruleSource;
    private String deprecation;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public RuleSource getSource() {
        return this.ruleSource;
    }

    @Override
    public String getDeprecation() {
        return this.deprecation;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractRule)) {
            return false;
        }
        AbstractRule that = (AbstractRule)o;
        return this.id.equals(that.id);
    }

    public final int hashCode() {
        return this.id.hashCode();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "{" + "id='" + this.id + '\'' + ", description='" + this.description + '\'' + ", ruleSource=" + this.ruleSource + '}';
    }

    protected static abstract class Builder<B extends Builder<B, R>, R extends AbstractRule> {
        protected AbstractRule rule;

        protected Builder(R rule) {
            this.rule = rule;
        }

        public R get() {
            return (R)this.rule;
        }

        protected B builder() {
            return (B)this;
        }

        public B id(String id) {
            this.rule.id = id;
            return this.builder();
        }

        public B description(String description) {
            this.rule.description = description;
            return this.builder();
        }

        public B ruleSource(RuleSource ruleSource) {
            this.rule.ruleSource = ruleSource;
            return this.builder();
        }

        public B deprecation(String deprecation) {
            this.rule.deprecation = deprecation;
            return this.builder();
        }
    }
}

