/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.core.analysis.api.rule;

import com.buschmais.jqassistant.core.analysis.api.rule.AbstractSeverityRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Executable;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Report;
import com.buschmais.jqassistant.core.analysis.api.rule.Verification;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AbstractExecutableRule
extends AbstractSeverityRule
implements ExecutableRule {
    private Executable executable;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Set<String> requiresConcepts = new HashSet<String>();
    private Verification verification;
    private Report report;

    @Override
    public Set<String> getRequiresConcepts() {
        return this.requiresConcepts;
    }

    @Override
    public Executable getExecutable() {
        return this.executable;
    }

    @Override
    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    @Override
    public Verification getVerification() {
        return this.verification;
    }

    @Override
    public Report getReport() {
        return this.report;
    }

    protected static abstract class Builder<B extends Builder<B, R>, R extends AbstractExecutableRule>
    extends AbstractSeverityRule.Builder<B, R> {
        protected Builder(R rule) {
            super(rule);
        }

        public B requiresConceptIds(Set<String> requiresConcepts) {
            AbstractExecutableRule r = (AbstractExecutableRule)this.get();
            r.requiresConcepts.addAll(requiresConcepts);
            return (B)((Builder)this.builder());
        }

        public B executable(Executable executable) {
            AbstractExecutableRule r = (AbstractExecutableRule)this.get();
            r.executable = executable;
            return (B)((Builder)this.builder());
        }

        public B parameters(Map<String, Object> parameters) {
            AbstractExecutableRule r = (AbstractExecutableRule)this.get();
            r.parameters.putAll(parameters);
            return (B)((Builder)this.builder());
        }

        public B verification(Verification verification) {
            AbstractExecutableRule r = (AbstractExecutableRule)this.get();
            r.verification = verification;
            return (B)((Builder)this.builder());
        }

        public B report(Report report) {
            AbstractExecutableRule r = (AbstractExecutableRule)this.get();
            r.report = report;
            return (B)((Builder)this.builder());
        }
    }
}

