/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.locking;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.tycho.locking.facade.FileLocker;
import org.eclipse.tycho.locking.facade.LockTimeoutException;

public class FileLockerImpl
implements FileLocker {
    private static final String LOCKFILE_SUFFIX = ".tycholock";
    private final Location lockFileLocation;
    final File lockMarkerFile;

    public FileLockerImpl(File file, Location anyLocation) {
        try {
            this.lockMarkerFile = file.isDirectory() ? new File(file, LOCKFILE_SUFFIX).getCanonicalFile() : new File(file.getParentFile(), file.getName() + LOCKFILE_SUFFIX).getCanonicalFile();
            if (this.lockMarkerFile.isDirectory()) {
                throw new RuntimeException("Lock marker file " + this.lockMarkerFile + " already exists and is a directory");
            }
            File parentDir = this.lockMarkerFile.getParentFile();
            if (!parentDir.isDirectory() && !parentDir.mkdirs()) {
                throw new RuntimeException("Could not create parent directory " + parentDir + " of lock marker file");
            }
            this.lockFileLocation = anyLocation.createLocation(null, null, false);
            this.lockFileLocation.set(this.lockMarkerFile.toURL(), false, this.lockMarkerFile.getAbsolutePath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void lock() {
        this.lock(10000L);
    }

    public void lock(long timeout) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("timeout must not be negative");
        }
        boolean success = false;
        long waitInterval = 50L;
        long maxTries = timeout / 50L + 1L;
        IOException ioException = null;
        for (long i = 0L; i < maxTries; ++i) {
            ioException = null;
            try {
                success = this.lockFileLocation.lock();
            }
            catch (IOException ioe) {
                ioException = ioe;
            }
            if (success) {
                return;
            }
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        String message = "lock timeout: Could not acquire lock on file " + this.lockFileLocation.getURL() + " for " + timeout + " msec";
        if (ioException != null) {
            throw new LockTimeoutException(message, (Throwable)ioException);
        }
        throw new LockTimeoutException(message);
    }

    public void release() {
        this.lockFileLocation.release();
        if (this.lockMarkerFile.isFile() && !this.lockMarkerFile.delete()) {
            this.lockMarkerFile.deleteOnExit();
        }
    }

    public boolean isLocked() {
        try {
            return this.lockFileLocation.isLocked();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

