/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.scm.cli.task;

import com.buschmais.jqassistant.core.analysis.api.CompoundRuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.RuleException;
import com.buschmais.jqassistant.core.analysis.api.RuleSelection;
import com.buschmais.jqassistant.core.analysis.api.RuleSetReader;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSet;
import com.buschmais.jqassistant.core.analysis.api.rule.RuleSetBuilder;
import com.buschmais.jqassistant.core.analysis.api.rule.source.FileRuleSource;
import com.buschmais.jqassistant.core.analysis.api.rule.source.RuleSource;
import com.buschmais.jqassistant.core.analysis.api.rule.source.UrlRuleSource;
import com.buschmais.jqassistant.core.plugin.api.PluginRepositoryException;
import com.buschmais.jqassistant.scm.cli.CliConfigurationException;
import com.buschmais.jqassistant.scm.cli.CliExecutionException;
import com.buschmais.jqassistant.scm.cli.task.AbstractTask;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAnalyzeTask
extends AbstractTask {
    private static final String CMDLINE_OPTION_R = "r";
    private static final String CMDLINE_OPTION_RULEDIRECTORY = "ruleDirectory";
    private static final String CMDLINE_OPTION_RULESURL = "rulesUrl";
    private static final String CMDLINE_OPTION_GROUPS = "groups";
    private static final String CMDLINE_OPTION_CONSTRAINTS = "constraints";
    private static final String CMDLINE_OPTION_CONCEPTS = "concepts";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAnalyzeTask.class);
    private final RuleSetReader ruleSetReader = new CompoundRuleSetReader();
    private URL rulesUrl;
    private String ruleDirectory;
    private List<String> conceptIds;
    private List<String> constraintIds;
    private List<String> groupIds;

    protected RuleSet getAvailableRules() throws CliExecutionException {
        ArrayList<RuleSource> sources = new ArrayList<RuleSource>();
        if (this.rulesUrl != null) {
            sources.add(new UrlRuleSource(this.rulesUrl));
        } else {
            List ruleSources;
            File selectedDirectory = new File(this.ruleDirectory);
            sources.addAll(this.readRulesDirectory(selectedDirectory));
            try {
                ruleSources = this.pluginRepository.getRulePluginRepository().getRuleSources();
            }
            catch (PluginRepositoryException e) {
                throw new CliExecutionException("Cannot get rule plugin repository.", e);
            }
            sources.addAll(ruleSources);
        }
        RuleSetBuilder ruleSetBuilder = RuleSetBuilder.newInstance();
        try {
            this.ruleSetReader.read(sources, ruleSetBuilder);
        }
        catch (RuleException e) {
            throw new CliExecutionException("Cannot read rules.", e);
        }
        return ruleSetBuilder.getRuleSet();
    }

    protected RuleSelection getRuleSelection(RuleSet ruleSet) throws CliExecutionException {
        return RuleSelection.Builder.select(ruleSet, this.groupIds, this.constraintIds, this.conceptIds);
    }

    private List<RuleSource> readRulesDirectory(File rulesDirectory) throws CliExecutionException {
        if (rulesDirectory.exists() && !rulesDirectory.isDirectory()) {
            throw new RuntimeException(rulesDirectory.getAbsolutePath() + " does not exist or is not a directory.");
        }
        LOGGER.info("Reading rules from directory " + rulesDirectory.getAbsolutePath());
        try {
            return FileRuleSource.getRuleSources(rulesDirectory);
        }
        catch (IOException e) {
            throw new CliExecutionException("Cannot read rules directory: " + rulesDirectory.getAbsolutePath(), e);
        }
    }

    @Override
    public void withOptions(CommandLine options) throws CliConfigurationException {
        String rulesUrl = this.getOptionValue(options, CMDLINE_OPTION_RULESURL, null);
        if (rulesUrl != null) {
            try {
                this.rulesUrl = new URL(rulesUrl);
            }
            catch (MalformedURLException e) {
                throw new CliConfigurationException("'" + rulesUrl + "' is not a valid URL.", e);
            }
        }
        this.ruleDirectory = this.getOptionValue(options, CMDLINE_OPTION_R, "jqassistant/rules");
        this.groupIds = this.getOptionValues(options, CMDLINE_OPTION_GROUPS, Collections.emptyList());
        this.constraintIds = this.getOptionValues(options, CMDLINE_OPTION_CONSTRAINTS, Collections.emptyList());
        this.conceptIds = this.getOptionValues(options, CMDLINE_OPTION_CONCEPTS, Collections.emptyList());
    }

    @Override
    protected void addTaskOptions(List<Option> options) {
        OptionBuilder.withArgName((String)CMDLINE_OPTION_R);
        OptionBuilder.withLongOpt((String)CMDLINE_OPTION_RULEDIRECTORY);
        OptionBuilder.withDescription((String)"The directory containing rules.");
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_R));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_RULESURL);
        OptionBuilder.withDescription((String)"The URL of a file containing rules.");
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_RULESURL));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_GROUPS);
        OptionBuilder.withDescription((String)"The groups to execute (default='default').");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_GROUPS));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_CONSTRAINTS);
        OptionBuilder.withDescription((String)"The constraints to verify.");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_CONSTRAINTS));
        OptionBuilder.withArgName((String)CMDLINE_OPTION_CONCEPTS);
        OptionBuilder.withDescription((String)"The concepts to apply.");
        OptionBuilder.withValueSeparator((char)',');
        OptionBuilder.hasArgs();
        options.add(OptionBuilder.create((String)CMDLINE_OPTION_CONCEPTS));
    }
}

