/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.maven3.impl.scanner;

import com.buschmais.jqassistant.core.scanner.api.Scanner;
import com.buschmais.jqassistant.core.scanner.api.ScannerContext;
import com.buschmais.jqassistant.core.scanner.api.Scope;
import com.buschmais.jqassistant.core.store.api.Store;
import com.buschmais.jqassistant.core.store.api.model.Descriptor;
import com.buschmais.jqassistant.plugin.common.api.model.ArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.DependsOnDescriptor;
import com.buschmais.jqassistant.plugin.common.api.model.FileDescriptor;
import com.buschmais.jqassistant.plugin.common.api.scanner.AbstractScannerPlugin;
import com.buschmais.jqassistant.plugin.java.api.model.JavaArtifactFileDescriptor;
import com.buschmais.jqassistant.plugin.java.api.model.JavaClassesDirectoryDescriptor;
import com.buschmais.jqassistant.plugin.java.api.scanner.ClasspathScopedTypeResolver;
import com.buschmais.jqassistant.plugin.java.api.scanner.JavaScope;
import com.buschmais.jqassistant.plugin.java.api.scanner.TypeResolver;
import com.buschmais.jqassistant.plugin.junit.api.scanner.JunitScope;
import com.buschmais.jqassistant.plugin.maven3.api.artifact.ArtifactResolver;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenArtifactDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenPomDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.model.MavenProjectDirectoryDescriptor;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.MavenScope;
import com.buschmais.jqassistant.plugin.maven3.api.scanner.ScanInclude;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.artifact.ArtifactCoordinates;
import com.buschmais.jqassistant.plugin.maven3.impl.scanner.artifact.MavenArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Model;
import org.apache.maven.project.MavenProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavenProjectScannerPlugin
extends AbstractScannerPlugin<MavenProject, MavenProjectDirectoryDescriptor> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MavenProjectScannerPlugin.class);

    public boolean accepts(MavenProject item, String path, Scope scope) throws IOException {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenProjectDirectoryDescriptor scan(MavenProject project, String path, Scope scope, Scanner scanner) throws IOException {
        ScannerContext context = scanner.getContext();
        MavenArtifactResolver artifactResolver = new MavenArtifactResolver();
        context.push(ArtifactResolver.class, (Object)artifactResolver);
        try {
            MavenProjectDirectoryDescriptor projectDescriptor = this.resolveProject(project, MavenProjectDirectoryDescriptor.class, context);
            HashMap<ArtifactFileDescriptor, Artifact> mainArtifactDependencies = new HashMap<ArtifactFileDescriptor, Artifact>();
            HashMap<ArtifactFileDescriptor, Artifact> testArtifactDependencies = new HashMap<ArtifactFileDescriptor, Artifact>();
            for (Artifact dependency : project.getDependencyArtifacts()) {
                MavenArtifactDescriptor dependencyDescriptor = this.getMavenArtifactDescriptor(new ArtifactCoordinates(dependency, false), artifactResolver, scanner);
                if (!"test".equals(dependency.getScope())) {
                    mainArtifactDependencies.put(dependencyDescriptor, dependency);
                }
                testArtifactDependencies.put(dependencyDescriptor, dependency);
            }
            Artifact artifact = project.getArtifact();
            MavenArtifactDescriptor mainArtifactDescriptor = this.getMavenArtifactDescriptor(new ArtifactCoordinates(artifact, false), artifactResolver, scanner);
            projectDescriptor.getCreatesArtifacts().add(mainArtifactDescriptor);
            this.addDependencies(mainArtifactDescriptor, mainArtifactDependencies, scanner.getContext());
            MavenArtifactDescriptor testArtifactDescriptor = null;
            String testOutputDirectory = project.getBuild().getTestOutputDirectory();
            if (testOutputDirectory != null) {
                testArtifactDescriptor = this.getMavenArtifactDescriptor(new ArtifactCoordinates(artifact, true), artifactResolver, scanner);
                projectDescriptor.getCreatesArtifacts().add(testArtifactDescriptor);
                testArtifactDependencies.put(mainArtifactDescriptor, artifact);
                this.addDependencies(testArtifactDescriptor, testArtifactDependencies, scanner.getContext());
            }
            this.scanClassesDirectory(projectDescriptor, mainArtifactDescriptor, project.getBuild().getOutputDirectory(), scanner);
            if (testOutputDirectory != null) {
                this.scanClassesDirectory(projectDescriptor, testArtifactDescriptor, testOutputDirectory, scanner);
            }
            this.addProjectDetails(project, projectDescriptor, scanner);
            this.scanPath(projectDescriptor, project.getBuild().getDirectory() + "/surefire-reports", (Scope)JunitScope.TESTREPORTS, scanner);
            this.scanPath(projectDescriptor, project.getBuild().getDirectory() + "/failsafe-reports", (Scope)JunitScope.TESTREPORTS, scanner);
            List scanIncludes = (List)this.getProperty(ScanInclude.class.getName(), List.class);
            if (scanIncludes != null) {
                for (ScanInclude scanInclude : scanIncludes) {
                    String scopeName = scanInclude.getScope();
                    Scope includeScope = scanner.resolveScope(scopeName);
                    this.scanPath(projectDescriptor, scanInclude.getPath(), includeScope, scanner);
                }
            }
            MavenProjectDirectoryDescriptor mavenProjectDirectoryDescriptor = projectDescriptor;
            return mavenProjectDirectoryDescriptor;
        }
        finally {
            context.pop(ArtifactResolver.class);
        }
    }

    private MavenArtifactDescriptor getMavenArtifactDescriptor(ArtifactCoordinates artifact, ArtifactResolver artifactResolver, Scanner scanner) {
        return artifactResolver.resolve(artifact, scanner.getContext());
    }

    protected <T extends MavenProjectDescriptor> T resolveProject(MavenProject project, Class<T> expectedType, ScannerContext scannerContext) {
        String id;
        Store store = scannerContext.getStore();
        MavenProjectDescriptor projectDescriptor = (MavenProjectDescriptor)store.find(MavenProjectDescriptor.class, id = project.getGroupId() + ":" + project.getArtifactId() + ":" + project.getVersion());
        if (projectDescriptor == null) {
            projectDescriptor = (MavenProjectDescriptor)store.create(expectedType, id);
            projectDescriptor.setName(project.getName());
            projectDescriptor.setGroupId(project.getGroupId());
            projectDescriptor.setArtifactId(project.getArtifactId());
            projectDescriptor.setVersion(project.getVersion());
            projectDescriptor.setPackaging(project.getPackaging());
            projectDescriptor.setFullQualifiedName(id);
        } else if (!expectedType.isAssignableFrom(projectDescriptor.getClass())) {
            projectDescriptor = (MavenProjectDescriptor)store.migrate((Descriptor)projectDescriptor, expectedType, new Class[0]);
        }
        return (T)((MavenProjectDescriptor)expectedType.cast(projectDescriptor));
    }

    private void addProjectDetails(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, Scanner scanner) {
        ScannerContext scannerContext = scanner.getContext();
        this.addParent(project, projectDescriptor, scannerContext);
        this.addModules(project, projectDescriptor, scannerContext);
        this.addModel(project, projectDescriptor, scanner);
    }

    private void addModel(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, Scanner scanner) {
        File pomXmlFile = project.getFile();
        FileDescriptor mavenPomXmlDescriptor = (FileDescriptor)scanner.scan((Object)pomXmlFile, pomXmlFile.getAbsolutePath(), (Scope)MavenScope.PROJECT);
        projectDescriptor.setModel(mavenPomXmlDescriptor);
        MavenPomDescriptor effectiveModelDescriptor = (MavenPomDescriptor)scanner.getContext().getStore().create(MavenPomDescriptor.class);
        Model model = project.getModel();
        scanner.getContext().push(MavenPomDescriptor.class, (Object)effectiveModelDescriptor);
        scanner.scan((Object)model, pomXmlFile.getAbsolutePath(), (Scope)MavenScope.PROJECT);
        scanner.getContext().pop(MavenPomDescriptor.class);
        projectDescriptor.setEffectiveModel(effectiveModelDescriptor);
    }

    private void addParent(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, ScannerContext scannerContext) {
        MavenProject parent = project.getParent();
        if (parent != null) {
            MavenProjectDescriptor parentDescriptor = this.resolveProject(parent, MavenProjectDescriptor.class, scannerContext);
            projectDescriptor.setParent(parentDescriptor);
        }
    }

    private void addModules(MavenProject project, MavenProjectDirectoryDescriptor projectDescriptor, ScannerContext scannerContext) {
        File projectDirectory = project.getBasedir();
        HashSet<File> modules = new HashSet<File>();
        for (String moduleName : project.getModules()) {
            File module = new File(projectDirectory, moduleName);
            modules.add(module);
        }
        for (MavenProject module : project.getCollectedProjects()) {
            if (!modules.contains(module.getBasedir())) continue;
            MavenProjectDescriptor moduleDescriptor = this.resolveProject(module, MavenProjectDescriptor.class, scannerContext);
            projectDescriptor.getModules().add(moduleDescriptor);
        }
    }

    private void addDependencies(ArtifactFileDescriptor artifactDescriptor, Map<ArtifactFileDescriptor, Artifact> dependencies, ScannerContext scannerContext) {
        for (Map.Entry<ArtifactFileDescriptor, Artifact> entry : dependencies.entrySet()) {
            ArtifactFileDescriptor dependencyDescriptor = entry.getKey();
            Artifact dependency = entry.getValue();
            DependsOnDescriptor dependsOnDescriptor = (DependsOnDescriptor)scannerContext.getStore().create((Descriptor)artifactDescriptor, DependsOnDescriptor.class, (Descriptor)dependencyDescriptor);
            dependsOnDescriptor.setScope(dependency.getScope());
            dependsOnDescriptor.setOptional(dependency.isOptional());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanClassesDirectory(MavenProjectDirectoryDescriptor projectDescriptor, MavenArtifactDescriptor artifactDescriptor, String directoryName, Scanner scanner) {
        File directory = new File(directoryName);
        if (directory.exists()) {
            JavaArtifactFileDescriptor javaArtifactFileDescriptor = (JavaArtifactFileDescriptor)scanner.getContext().getStore().addDescriptorType((Descriptor)artifactDescriptor, JavaClassesDirectoryDescriptor.class);
            ScannerContext context = scanner.getContext();
            context.push(JavaArtifactFileDescriptor.class, (Object)javaArtifactFileDescriptor);
            ClasspathScopedTypeResolver typeResolver = new ClasspathScopedTypeResolver(javaArtifactFileDescriptor);
            context.push(TypeResolver.class, (Object)typeResolver);
            try {
                this.scanPath(projectDescriptor, directoryName, (Scope)JavaScope.CLASSPATH, scanner);
            }
            finally {
                context.pop(TypeResolver.class);
                context.pop(JavaArtifactFileDescriptor.class);
            }
        }
    }

    private <F extends FileDescriptor> F scanPath(MavenProjectDirectoryDescriptor projectDescriptor, String path, Scope scope, Scanner scanner) {
        File file = new File(path);
        if (file.exists()) {
            return this.scanPath(projectDescriptor, file, path, scope, scanner);
        }
        LOGGER.debug(file.getAbsolutePath() + " does not exist, skipping.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <F extends FileDescriptor> F scanPath(MavenProjectDirectoryDescriptor projectDescriptor, File directory, String path, Scope scope, Scanner scanner) {
        scanner.getContext().push(MavenProjectDirectoryDescriptor.class, (Object)projectDescriptor);
        try {
            FileDescriptor fileDescriptor = (FileDescriptor)scanner.scan((Object)directory, path, scope);
            if (fileDescriptor != null) {
                projectDescriptor.getContains().add(fileDescriptor);
            }
            FileDescriptor fileDescriptor2 = fileDescriptor;
            return (F)fileDescriptor2;
        }
        finally {
            scanner.getContext().pop(MavenProjectDirectoryDescriptor.class);
        }
    }
}

