/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.shared.reflection.ClassHelper;
import com.buschmais.jqassistant.core.store.api.model.SubGraph;
import com.buschmais.jqassistant.plugin.graphml.report.api.GraphMLDecorator;
import com.buschmais.jqassistant.plugin.graphml.report.impl.GraphMLNamespaceContext;
import com.buschmais.jqassistant.plugin.graphml.report.impl.MetaInformation;
import com.buschmais.xo.api.CompositeObject;
import com.sun.xml.txw2.output.IndentingXMLStreamWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;

class XmlGraphMLWriter {
    private static final String GRAPHML_DECORATOR = "graphml.report.decorator";
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private ClassHelper classHelper;
    private Class<? extends GraphMLDecorator> defaultDecoratorClass;
    private Map<String, Object> properties;

    XmlGraphMLWriter(ClassHelper classHelper, Class<? extends GraphMLDecorator> defaultDecoratorClass, Map<String, Object> properties) {
        this.classHelper = classHelper;
        this.defaultDecoratorClass = defaultDecoratorClass;
        this.properties = properties;
    }

    void write(Result<?> result, SubGraph graph, File file) throws IOException, XMLStreamException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(file));
             GraphMLDecorator decorator = this.getGraphMLDecorator(result);){
            IndentingXMLStreamWriter xmlWriter = new IndentingXMLStreamWriter(xmlOutputFactory.createXMLStreamWriter(writer));
            decorator.initialize(result, graph, (XMLStreamWriter)xmlWriter, file, this.properties);
            GraphMLNamespaceContext context = new GraphMLNamespaceContext(decorator.getNamespaces(), decorator.getSchemaLocations());
            xmlWriter.setNamespaceContext(context);
            this.writeHeader((XMLStreamWriter)xmlWriter, context);
            Collection<CompositeObject> allCompositeNodes = this.getAllNodes(graph);
            Collection<CompositeObject> allCompositeRelationships = this.getAllRelationships(graph);
            this.writeKeyTypes((XMLStreamWriter)xmlWriter, allCompositeNodes, allCompositeRelationships);
            decorator.writeKeys();
            this.writeSubgraph(graph, (XMLStreamWriter)xmlWriter, decorator);
            HashSet<Long> allNodeIds = new HashSet<Long>();
            for (CompositeObject compositeObject : allCompositeNodes) {
                allNodeIds.add(((Node)compositeObject.getDelegate()).getId());
            }
            for (CompositeObject compositeRelationship : allCompositeRelationships) {
                Relationship relationship = (Relationship)compositeRelationship.getDelegate();
                long startId = relationship.getStartNode().getId();
                long endId = relationship.getEndNode().getId();
                if (!allNodeIds.contains(startId) || !allNodeIds.contains(endId)) continue;
                this.writeRelationship((XMLStreamWriter)xmlWriter, decorator, compositeRelationship);
            }
            this.writeFooter((XMLStreamWriter)xmlWriter);
            decorator.close();
        }
    }

    private GraphMLDecorator getGraphMLDecorator(Result<?> result) {
        String graphMLDecorator = result.getRule().getReport().getProperties().getProperty(GRAPHML_DECORATOR);
        Class decoratorClass = graphMLDecorator != null ? this.classHelper.getType(graphMLDecorator) : this.defaultDecoratorClass;
        return (GraphMLDecorator)this.classHelper.createInstance(decoratorClass);
    }

    private void writeSubgraph(SubGraph graph, XMLStreamWriter writer, GraphMLDecorator decorator) throws XMLStreamException, IOException {
        CompositeObject wrapperNode = graph.getParentNode();
        if (wrapperNode != null) {
            this.writeNode(writer, decorator, wrapperNode, false);
        }
        writer.writeStartElement("graph");
        writer.writeAttribute("id", "G" + graph.hashCode());
        writer.writeAttribute("edgedefault", "directed");
        this.newLine(writer);
        for (CompositeObject node : graph.getNodes()) {
            this.writeNode(writer, decorator, node, true);
        }
        for (SubGraph subgraph : graph.getSubGraphs()) {
            this.writeSubgraph(subgraph, writer, decorator);
        }
        this.endElement(writer);
        if (wrapperNode != null) {
            writer.writeEndElement();
        }
    }

    private void writeKeyTypes(XMLStreamWriter writer, Collection<CompositeObject> allNodes, Collection<CompositeObject> allRelationships) throws IOException, XMLStreamException {
        HashMap<String, Class> keyTypes = new HashMap<String, Class>();
        keyTypes.put("labels", String.class);
        for (CompositeObject node : allNodes) {
            this.updateKeyTypes(keyTypes, node);
        }
        this.writeKeyTypes(writer, keyTypes, "node");
        keyTypes.clear();
        for (CompositeObject rel : allRelationships) {
            this.updateKeyTypes(keyTypes, rel);
        }
        this.writeKeyTypes(writer, keyTypes, "edge");
    }

    private void writeKeyTypes(XMLStreamWriter writer, Map<String, Class> keyTypes, String forType) throws IOException, XMLStreamException {
        for (Map.Entry<String, Class> entry : keyTypes.entrySet()) {
            String type = MetaInformation.typeFor(entry.getValue(), MetaInformation.GRAPHML_ALLOWED);
            if (type == null) continue;
            writer.writeEmptyElement("key");
            writer.writeAttribute("id", entry.getKey());
            writer.writeAttribute("for", forType);
            writer.writeAttribute("attr.name", entry.getKey());
            writer.writeAttribute("attr.type", type);
            this.newLine(writer);
        }
    }

    private void updateKeyTypes(Map<String, Class> keyTypes, CompositeObject composite) {
        PropertyContainer pc = (PropertyContainer)composite.getDelegate();
        this.updateKeyTypes(keyTypes, pc);
    }

    private void updateKeyTypes(Map<String, Class> keyTypes, PropertyContainer pc) {
        for (String prop : pc.getPropertyKeys()) {
            Object value = pc.getProperty(prop);
            Class storedClass = keyTypes.get(prop);
            if (storedClass == null) {
                keyTypes.put(prop, value.getClass());
                continue;
            }
            if (storedClass == Void.TYPE || storedClass.equals(value.getClass())) continue;
            keyTypes.put(prop, Void.TYPE);
        }
    }

    private void writeNode(XMLStreamWriter writer, GraphMLDecorator decorator, CompositeObject composite, boolean withEnd) throws IOException, XMLStreamException {
        if (decorator.isWriteNode(composite)) {
            Node node = (Node)composite.getDelegate();
            writer.writeStartElement("node");
            writer.writeAttribute("id", this.id(node));
            decorator.writeNodeAttributes(composite);
            this.writeLabels(writer, node);
            this.writeLabelsAsData(writer, node);
            decorator.writeNodeElements(composite);
            this.writeProps(writer, (PropertyContainer)node);
            if (withEnd) {
                this.endElement(writer);
            }
        }
    }

    private String id(Node node) {
        return "n" + node.getId();
    }

    private void writeLabels(XMLStreamWriter writer, Node node) throws IOException, XMLStreamException {
        String labelsString = MetaInformation.getLabelsString(node);
        if (!labelsString.isEmpty()) {
            writer.writeAttribute("labels", labelsString);
        }
    }

    private void writeLabelsAsData(XMLStreamWriter writer, Node node) throws IOException, XMLStreamException {
        String labelsString = MetaInformation.getLabelsString(node);
        if (labelsString.isEmpty()) {
            return;
        }
        this.writeData(writer, "labels", labelsString);
    }

    private void writeRelationship(XMLStreamWriter writer, GraphMLDecorator decorator, CompositeObject coRel) throws IOException, XMLStreamException {
        Relationship rel = (Relationship)coRel.getDelegate();
        if (decorator.isWriteRelationship(coRel)) {
            writer.writeStartElement("edge");
            writer.writeAttribute("id", this.id(rel));
            writer.writeAttribute("source", this.id(rel.getStartNode()));
            writer.writeAttribute("target", this.id(rel.getEndNode()));
            writer.writeAttribute("label", rel.getType().name());
            decorator.writeRelationshipAttributes(coRel);
            this.writeData(writer, "label", rel.getType().name());
            decorator.writeRelationshipElements(coRel);
            this.writeProps(writer, (PropertyContainer)rel);
            this.endElement(writer);
        }
    }

    private String id(Relationship rel) {
        return "e" + rel.getId();
    }

    private void endElement(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        this.newLine(writer);
    }

    private void writeProps(XMLStreamWriter writer, PropertyContainer node) throws IOException, XMLStreamException {
        int count = 0;
        for (String prop : node.getPropertyKeys()) {
            Object value = node.getProperty(prop);
            this.writeData(writer, prop, value);
            ++count;
        }
    }

    private void writeData(XMLStreamWriter writer, String prop, Object value) throws IOException, XMLStreamException {
        writer.writeStartElement("data");
        writer.writeAttribute("key", prop);
        if (value != null) {
            writer.writeCharacters(value.toString());
        }
        writer.writeEndElement();
    }

    private void writeFooter(XMLStreamWriter writer) throws IOException, XMLStreamException {
        this.endElement(writer);
        writer.writeEndDocument();
    }

    private void writeHeader(XMLStreamWriter writer, GraphMLNamespaceContext context) throws IOException, XMLStreamException {
        writer.writeStartDocument("UTF-8", "1.0");
        this.newLine(writer);
        writer.writeStartElement("graphml");
        writer.writeNamespace("xmlns", "http://graphml.graphdrawing.org/xmlns");
        for (Map.Entry<String, String> entry : context.getNamespaces().entrySet()) {
            writer.writeAttribute("xmlns", "http://graphml.graphdrawing.org/xmlns", entry.getKey(), entry.getValue());
        }
        if (!context.getSchemaLocations().isEmpty()) {
            StringBuilder schemaLocations = new StringBuilder();
            for (Map.Entry<String, String> entry : context.getSchemaLocations().entrySet()) {
                schemaLocations.append(entry.getKey()).append(" ").append(entry.getValue());
            }
            writer.writeAttribute("xsi", "", "schemaLocation", schemaLocations.toString());
        }
        this.newLine(writer);
    }

    private void newLine(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n");
    }

    private Collection<CompositeObject> getAllNodes(SubGraph graph) {
        LinkedHashSet<CompositeObject> allNodes = new LinkedHashSet<CompositeObject>();
        CompositeObject parentNode = graph.getParentNode();
        if (parentNode != null) {
            allNodes.add(parentNode);
        }
        allNodes.addAll(graph.getNodes());
        for (SubGraph subgraph : graph.getSubGraphs()) {
            allNodes.addAll(subgraph.getNodes());
        }
        return allNodes;
    }

    private Collection<CompositeObject> getAllRelationships(SubGraph graph) {
        LinkedHashSet<CompositeObject> allRels = new LinkedHashSet<CompositeObject>();
        allRels.addAll(graph.getRelationships());
        for (SubGraph subgraph : graph.getSubGraphs()) {
            allRels.addAll(subgraph.getRelationships());
        }
        return allRels;
    }
}

