/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.jqassistant.core.store.api.model.SubGraph;
import com.buschmais.jqassistant.plugin.graphml.report.impl.SubGraphImpl;
import com.buschmais.jqassistant.plugin.graphml.report.impl.VirtualPropertyContainer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ReturnableEvaluator;
import org.neo4j.graphdb.StopEvaluator;
import org.neo4j.graphdb.Traverser;

public class VirtualNode
extends VirtualPropertyContainer
implements Node {
    private static long NODE_ID = -1L;
    private static final String ROLE_NODE = "node";
    private long id;
    private final List<Relationship> relationships = new ArrayList<Relationship>();
    private final List<Label> labels = new ArrayList<Label>();
    private final Set<SubGraph> subgraphs = new LinkedHashSet<SubGraph>();

    public static boolean isNode(Map<String, Object> m) {
        return ROLE_NODE.equals(m.get("role"));
    }

    public VirtualNode(Map<String, Object> m) {
        super(m);
        long l;
        if (!VirtualNode.isNode(m)) {
            throw new IllegalArgumentException("Not a node-map " + m);
        }
        if (m.containsKey("id")) {
            l = ((Number)m.get("id")).longValue();
        } else {
            long l2 = NODE_ID;
            l = l2;
            NODE_ID = l2 - 1L;
        }
        this.id = l;
        if (m.containsKey("relationships")) {
            this.relationships.addAll((List)m.get("relationships"));
        }
        if (m.containsKey("labels")) {
            List labelList = (List)m.get("labels");
            for (Object label : labelList) {
                if (label instanceof Label) {
                    this.labels.add((Label)label);
                    continue;
                }
                this.labels.add(DynamicLabel.label((String)label.toString()));
            }
        }
    }

    public void add(Object o) {
        if (o instanceof SubGraphImpl) {
            this.subgraphs.add((SubGraph)o);
        } else if (o instanceof Iterable) {
            for (Object iterOb : (Iterable)o) {
                this.add(iterOb);
            }
        }
    }

    public long getId() {
        return this.id;
    }

    public void delete() {
    }

    public Iterable<Relationship> getRelationships() {
        return this.relationships;
    }

    public boolean hasRelationship() {
        return !this.relationships.isEmpty();
    }

    public Iterable<Relationship> getRelationships(RelationshipType ... types) {
        List<RelationshipType> relTypes = Arrays.asList(types);
        ArrayList<Relationship> returnRels = new ArrayList<Relationship>(this.relationships.size());
        for (Relationship relationship : this.relationships) {
            if (!relTypes.contains(relationship.getType())) continue;
            returnRels.add(relationship);
        }
        return returnRels;
    }

    public Iterable<Relationship> getRelationships(Direction direction, RelationshipType ... types) {
        List<RelationshipType> relTypes = Arrays.asList(types);
        ArrayList<Relationship> returnRels = new ArrayList<Relationship>(this.relationships.size());
        for (Relationship relationship : this.relationships) {
            if (!relTypes.contains(relationship.getType())) continue;
            returnRels.add(relationship);
        }
        return null;
    }

    public boolean hasRelationship(RelationshipType ... types) {
        List<RelationshipType> relTypes = Arrays.asList(types);
        for (Relationship relationship : this.relationships) {
            if (!relTypes.contains(relationship.getType())) continue;
            return true;
        }
        return false;
    }

    public boolean hasRelationship(Direction direction, RelationshipType ... types) {
        List<RelationshipType> relTypes = Arrays.asList(types);
        for (Relationship relationship : this.relationships) {
            if (!relTypes.contains(relationship.getType())) continue;
            return true;
        }
        return false;
    }

    public Iterable<Relationship> getRelationships(Direction dir) {
        return null;
    }

    public boolean hasRelationship(Direction dir) {
        return false;
    }

    public Iterable<Relationship> getRelationships(RelationshipType type, Direction dir) {
        return this.getRelationships(dir, type);
    }

    public boolean hasRelationship(RelationshipType type, Direction dir) {
        return this.hasRelationship(dir, type);
    }

    public Relationship getSingleRelationship(RelationshipType type, Direction dir) {
        Iterable<Relationship> rels = this.getRelationships(type, dir);
        Iterator<Relationship> iterator = rels.iterator();
        if (iterator.hasNext()) {
            Relationship relationship = iterator.next();
            if (iterator.hasNext()) {
                throw new RuntimeException("More than one relationship with type=" + type + " and dir=" + dir + " on node " + this);
            }
            return relationship;
        }
        return null;
    }

    public Relationship createRelationshipTo(Node otherNode, RelationshipType type) {
        throw new UnsupportedOperationException();
    }

    public Iterable<RelationshipType> getRelationshipTypes() {
        HashSet<RelationshipType> types = new HashSet<RelationshipType>();
        for (Relationship relationship : this.relationships) {
            types.add(relationship.getType());
        }
        return types;
    }

    public int getDegree() {
        return this.relationships.size();
    }

    public int getDegree(RelationshipType type) {
        return ((List)this.getRelationships(type)).size();
    }

    public int getDegree(Direction direction) {
        return ((List)this.getRelationships(direction)).size();
    }

    public int getDegree(RelationshipType type, Direction direction) {
        return ((List)this.getRelationships(type, direction)).size();
    }

    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType relationshipType, Direction direction) {
        throw new UnsupportedOperationException();
    }

    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, RelationshipType firstRelationshipType, Direction firstDirection, RelationshipType secondRelationshipType, Direction secondDirection) {
        throw new UnsupportedOperationException();
    }

    public Traverser traverse(Traverser.Order traversalOrder, StopEvaluator stopEvaluator, ReturnableEvaluator returnableEvaluator, Object ... relationshipTypesAndDirections) {
        throw new UnsupportedOperationException();
    }

    public void addLabel(Label label) {
        this.labels.add(label);
    }

    public void removeLabel(Label label) {
        this.labels.remove(label);
    }

    public boolean hasLabel(Label label) {
        return this.labels.contains(label);
    }

    public Iterable<Label> getLabels() {
        return this.labels;
    }
}

