/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.jqassistant.core.store.api.model.SubGraph;
import com.buschmais.jqassistant.plugin.graphml.report.impl.MetaInformation;
import com.buschmais.xo.api.CompositeObject;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;

class SubGraphImpl
implements SubGraph {
    private static final String ROLE_GRAPH = "graph";
    private CompositeObject parentNode;
    private Map<Long, SubGraph> subgraphs = new LinkedHashMap<Long, SubGraph>();
    private Map<Long, CompositeObject> nodes = new LinkedHashMap<Long, CompositeObject>();
    private Map<Long, CompositeObject> relationships = new LinkedHashMap<Long, CompositeObject>();

    SubGraphImpl() {
    }

    SubGraphImpl(Map m) {
        if (!SubGraphImpl.isSubgraph(m)) {
            throw new IllegalArgumentException("the argument m (" + m + ") is not a subgraph map");
        }
        if (m.containsKey("nodes")) {
            this.add(m.get("nodes"));
        }
        if (m.containsKey("relationships")) {
            this.add(m.get("relationships"));
        }
        if (m.containsKey("parent")) {
            this.parentNode = (CompositeObject)m.get("parent");
        }
    }

    public CompositeObject getParentNode() {
        return this.parentNode;
    }

    public Collection<CompositeObject> getNodes() {
        return this.nodes.values();
    }

    public Collection<CompositeObject> getRelationships() {
        return this.relationships.values();
    }

    public void add(Object value) {
        if (value instanceof CompositeObject) {
            CompositeObject compositeObject = (CompositeObject)value;
            Long id = (Long)compositeObject.getId();
            Object o = compositeObject.getDelegate();
            if (o instanceof Node) {
                this.nodes.put(id, compositeObject);
            } else if (o instanceof Relationship) {
                this.relationships.put(id, compositeObject);
            } else {
                this.add(o);
            }
        } else if (value instanceof SubGraphImpl) {
            SubGraph subGraph = (SubGraph)value;
            this.subgraphs.put(subGraph.getId(), subGraph);
        } else if (value instanceof Relationship) {
            Relationship rel = (Relationship)value;
            this.relationships.put(rel.getId(), new RelationWrapper(rel));
        } else if (value instanceof Node) {
            Node node = (Node)value;
            this.nodes.put(node.getId(), new NodeWrapper(node));
        } else if (value instanceof Iterable) {
            for (Object o : (Iterable)value) {
                this.add(o);
            }
        }
    }

    static boolean isSubgraph(Map m) {
        return ROLE_GRAPH.equals(m.get("role"));
    }

    public Collection<SubGraph> getSubGraphs() {
        return this.subgraphs.values();
    }

    public Long getId() {
        return (Long)this.parentNode.getId();
    }

    private class NodeWrapper
    implements CompositeObject {
        private Node node;

        NodeWrapper(Node node) {
            this.node = node;
        }

        public Long getId() {
            return this.node.getId();
        }

        public <T> T as(Class<T> type) {
            return null;
        }

        public Node getDelegate() {
            return this.node;
        }

        public String toString() {
            return "VirtualNode[labels=" + MetaInformation.getLabelsString(this.node) + "]";
        }
    }

    private class RelationWrapper
    implements CompositeObject {
        private Relationship rel;

        RelationWrapper(Relationship rel) {
            this.rel = rel;
        }

        public Long getId() {
            return this.rel.getId();
        }

        public <T> T as(Class<T> type) {
            return null;
        }

        public Relationship getDelegate() {
            return this.rel;
        }

        public String toString() {
            return "VirtualRelationship[type=" + this.rel.getType().name() + "]";
        }
    }
}

