/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;

public class MetaInformation {
    public static final Set<String> GRAPHML_ALLOWED = new HashSet<String>(Arrays.asList("boolean", "int", "long", "float", "double", "string"));

    public static String typeFor(Class value, Set<String> allowed) {
        if (value == Void.TYPE) {
            return null;
        }
        if (value.isArray()) {
            return null;
        }
        String name = value.getSimpleName().toLowerCase();
        if (name.equals("integer")) {
            name = "int";
        }
        if (allowed == null || allowed.contains(name)) {
            return name;
        }
        if (Number.class.isAssignableFrom(value)) {
            return "int";
        }
        return null;
    }

    public static String getLabelsString(Node node) {
        HashSet<String> labels = new HashSet<String>();
        for (Label l : node.getLabels()) {
            labels.add(l.name());
        }
        if (labels.isEmpty()) {
            return "";
        }
        return ":" + StringUtils.join(labels.iterator(), (String)":");
    }
}

