/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.plugin.graphml.report.impl;

import com.buschmais.jqassistant.core.analysis.api.Result;
import com.buschmais.jqassistant.core.analysis.api.rule.Concept;
import com.buschmais.jqassistant.core.analysis.api.rule.Constraint;
import com.buschmais.jqassistant.core.analysis.api.rule.ExecutableRule;
import com.buschmais.jqassistant.core.analysis.api.rule.Group;
import com.buschmais.jqassistant.core.report.api.ReportException;
import com.buschmais.jqassistant.core.report.api.ReportPlugin;
import com.buschmais.jqassistant.core.shared.reflection.ClassHelper;
import com.buschmais.jqassistant.core.store.api.model.SubGraph;
import com.buschmais.jqassistant.plugin.graphml.report.decorator.YedGraphMLDecorator;
import com.buschmais.jqassistant.plugin.graphml.report.impl.SubGraphImpl;
import com.buschmais.jqassistant.plugin.graphml.report.impl.VirtualNode;
import com.buschmais.jqassistant.plugin.graphml.report.impl.VirtualRelationship;
import com.buschmais.jqassistant.plugin.graphml.report.impl.XmlGraphMLWriter;
import com.buschmais.xo.api.CompositeObject;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphMLReportPlugin
implements ReportPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(GraphMLReportPlugin.class);
    public static final String GRAPHML = "graphml";
    public static final String FILEEXTENSION_GRAPHML = ".graphml";
    private static final String CONCEPT_PATTERN = "graphml.report.conceptPattern";
    private static final String DIRECTORY = "graphml.report.directory";
    private static final String GRAPHML_DEFAULT_DECORATOR = "graphml.report.defaultDecorator";
    private String conceptPattern = ".*\\.graphml$";
    private String directory = "jqassistant/report";
    private XmlGraphMLWriter xmlGraphMLWriter;

    public void initialize() throws ReportException {
    }

    public void configure(Map<String, Object> properties) throws ReportException {
        this.conceptPattern = this.getProperty(properties, CONCEPT_PATTERN, this.conceptPattern);
        this.directory = this.getProperty(properties, DIRECTORY, this.directory);
        String defaultDecorator = this.getProperty(properties, GRAPHML_DEFAULT_DECORATOR, YedGraphMLDecorator.class.getName());
        ClassHelper classHelper = new ClassHelper(GraphMLReportPlugin.class.getClassLoader());
        Class defaultDecoratorType = classHelper.getType(defaultDecorator);
        this.xmlGraphMLWriter = new XmlGraphMLWriter(classHelper, defaultDecoratorType, properties);
    }

    private String getProperty(Map<String, Object> properties, String property, String defaultValue) throws ReportException {
        String value = (String)properties.get(property);
        return value != null ? value : defaultValue;
    }

    public void begin() throws ReportException {
    }

    public void end() throws ReportException {
    }

    public void beginConcept(Concept concept) throws ReportException {
    }

    public void endConcept() throws ReportException {
    }

    public void beginGroup(Group group) throws ReportException {
    }

    public void endGroup() throws ReportException {
    }

    public void beginConstraint(Constraint constraint) throws ReportException {
    }

    public void endConstraint() throws ReportException {
    }

    public void setResult(Result<? extends ExecutableRule> result) throws ReportException {
        ExecutableRule rule = result.getRule();
        Set selectedReports = result.getRule().getReport().getSelectedTypes();
        if (selectedReports != null && selectedReports.contains(GRAPHML) || rule instanceof Concept && rule.getId().matches(this.conceptPattern)) {
            SubGraph subGraph = this.getSubGraph(result);
            try {
                File directory;
                String fileName = rule.getId().replaceAll("\\:", "_");
                if (!fileName.endsWith(FILEEXTENSION_GRAPHML)) {
                    fileName = fileName + FILEEXTENSION_GRAPHML;
                }
                if ((directory = new File(this.directory)).mkdirs()) {
                    LOGGER.info("Created directory " + directory.getAbsolutePath());
                }
                File file = new File(directory, fileName);
                this.xmlGraphMLWriter.write(result, subGraph, file);
            }
            catch (IOException | XMLStreamException e) {
                throw new ReportException("Cannot write custom report.", (Throwable)e);
            }
        }
    }

    private SubGraph getSubGraph(Result<? extends ExecutableRule> result) {
        SubGraphImpl subGraph = new SubGraphImpl();
        for (Map row : result.getRows()) {
            for (Object value : row.values()) {
                if (value instanceof Map) {
                    Map m = (Map)value;
                    if (VirtualRelationship.isRelationship(m)) {
                        subGraph.add(new VirtualRelationship(m));
                    }
                    if (VirtualNode.isNode(m)) {
                        subGraph.add(new VirtualNode(m));
                    }
                    if (SubGraphImpl.isSubgraph(m)) {
                        subGraph.add(new SubGraphImpl(m));
                    }
                }
                if (!(value instanceof CompositeObject)) continue;
                subGraph.add(value);
            }
        }
        return subGraph;
    }
}

