/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking.cache;

import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.full.ConsistencyCheckerTask;
import org.neo4j.consistency.checking.full.Stage;
import org.neo4j.consistency.checking.full.StoreProcessor;
import org.neo4j.consistency.statistics.Statistics;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.StoreAccess;
import org.neo4j.kernel.impl.store.record.NodeRecord;

public abstract class CacheTask
extends ConsistencyCheckerTask {
    protected final Stage stage;
    protected final CacheAccess cacheAccess;

    public CacheTask(Stage stage, CacheAccess cacheAccess) {
        super("CacheTask-" + stage, Statistics.NONE, 1);
        this.stage = stage;
        this.cacheAccess = cacheAccess;
    }

    @Override
    public void run() {
        if (this.stage.getCacheSlotSizes().length > 0) {
            this.cacheAccess.setCacheSlotSizes(this.stage.getCacheSlotSizes());
        }
        this.processCache();
    }

    protected abstract void processCache();

    public static class CheckNextRel
    extends CacheTask {
        private final StoreAccess storeAccess;
        private final StoreProcessor storeProcessor;

        public CheckNextRel(Stage stage, CacheAccess cacheAccess, StoreAccess storeAccess, StoreProcessor storeProcessor) {
            super(stage, cacheAccess);
            this.storeAccess = storeAccess;
            this.storeProcessor = storeProcessor;
        }

        @Override
        protected void processCache() {
            RecordStore nodeStore = this.storeAccess.getNodeStore();
            CacheAccess.Client client = this.cacheAccess.client();
            for (long nodeId = 0L; nodeId < nodeStore.getHighId(); ++nodeId) {
                NodeRecord node;
                if (client.getFromCache(nodeId, 1) != 0L || (node = (NodeRecord)nodeStore.forceGetRecord(nodeId)).isDense()) continue;
                this.storeProcessor.processNode((RecordStore<NodeRecord>)nodeStore, node);
            }
        }
    }

    public static class CacheNextRel
    extends CacheTask {
        private final Iterable<NodeRecord> nodes;

        public CacheNextRel(Stage stage, CacheAccess cacheAccess, Iterable<NodeRecord> nodes) {
            super(stage, cacheAccess);
            this.nodes = nodes;
        }

        @Override
        protected void processCache() {
            this.cacheAccess.clearCache();
            long[] fields = new long[]{1L, 0L, -1L};
            CacheAccess.Client client = this.cacheAccess.client();
            for (NodeRecord node : this.nodes) {
                if (!node.inUse()) continue;
                fields[2] = node.getNextRel();
                client.putToCache(node.getId(), fields);
            }
        }
    }
}

