/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.spi.reflection;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DependencyResolver<T> {
    private final Collection<T> elements;
    private final DependencyProvider<T> dependencyProvider;
    private Map<T, Set<T>> blockedBy;

    private DependencyResolver(Collection<T> elements, DependencyProvider<T> dependencyProvider) {
        this.elements = elements;
        this.dependencyProvider = dependencyProvider;
    }

    public static <T> DependencyResolver<T> newInstance(Collection<T> elements, DependencyProvider<T> dependencyProvider) {
        return new DependencyResolver<T>(elements, dependencyProvider);
    }

    public List<T> resolve() {
        this.blockedBy = new HashMap<T, Set<T>>();
        LinkedHashSet<T> queue = new LinkedHashSet<T>();
        HashSet allElements = new HashSet();
        queue.addAll(this.elements);
        while (!queue.isEmpty()) {
            Object element = queue.iterator().next();
            Set<T> dependencies = this.dependencyProvider.getDependencies(element);
            queue.addAll(dependencies);
            this.blockedBy.put(element, dependencies);
            queue.remove(element);
            allElements.add(element);
        }
        LinkedList result = new LinkedList();
        for (Object element : allElements) {
            this.resolve(element, result);
        }
        return result;
    }

    private void resolve(T element, List<T> result) {
        Set<T> dependencies = this.blockedBy.get(element);
        if (dependencies != null) {
            for (T dependency : dependencies) {
                this.resolve(dependency, result);
            }
            this.blockedBy.remove(element);
            result.add(element);
        }
    }

    @FunctionalInterface
    public static interface DependencyProvider<T> {
        public Set<T> getDependencies(T var1);
    }
}

