/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.xo.spi.metadata;

import com.buschmais.xo.api.CompositeType;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CompositeTypeBuilder {
    private static final ClassComparator COMPARATOR = new ClassComparator();

    private CompositeTypeBuilder() {
    }

    public static CompositeType create(Class<?> baseType, Class<?> ... types) {
        TreeSet classes = new TreeSet(COMPARATOR);
        classes.add(baseType);
        CompositeTypeBuilder.addTypes(classes, types);
        return CompositeTypeBuilder.getCompositeType(classes);
    }

    public static CompositeType create(Class<?> baseType, Class<?> type, Class<?>[] types) {
        TreeSet classes = new TreeSet(COMPARATOR);
        classes.add(baseType);
        classes.add(type);
        CompositeTypeBuilder.addTypes(classes, types);
        return CompositeTypeBuilder.getCompositeType(classes);
    }

    public static <T> CompositeType create(Class<?> baseType, Collection<T> types, Function<T, Class<?>> typeMapper) {
        TreeSet classes = new TreeSet(COMPARATOR);
        classes.add(baseType);
        for (T type : types) {
            classes.add(typeMapper.apply(type));
        }
        return CompositeTypeBuilder.getCompositeType(classes);
    }

    private static void addTypes(SortedSet<Class<?>> classes, Class<?>[] types) {
        for (Class<?> additionalType : types) {
            classes.add(additionalType);
        }
    }

    private static CompositeTypeImpl getCompositeType(Set<Class<?>> classes) {
        CompositeTypeImpl compositeType = new CompositeTypeImpl();
        CompositeTypeImpl.access$202(compositeType, classes.toArray(new Class[classes.size()]));
        compositeType.hashCode = Arrays.hashCode(compositeType.classes);
        return compositeType;
    }

    private static class CompositeTypeImpl
    implements CompositeType {
        private Class<?>[] classes;
        private int hashCode;

        private CompositeTypeImpl() {
        }

        public Class<?>[] getClasses() {
            return this.classes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CompositeTypeImpl)) {
                return false;
            }
            CompositeTypeImpl that = (CompositeTypeImpl)o;
            return Arrays.equals(this.classes, that.classes);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return Arrays.asList(this.classes).toString();
        }

        static /* synthetic */ Class[] access$202(CompositeTypeImpl x0, Class[] x1) {
            x0.classes = x1;
            return x1;
        }
    }

    @FunctionalInterface
    public static interface Function<T, R> {
        public R apply(T var1);
    }

    private static final class ClassComparator
    implements Comparator<Class<?>> {
        private ClassComparator() {
        }

        @Override
        public int compare(Class<?> type1, Class<?> type2) {
            if (type1.equals(type2)) {
                return 0;
            }
            if (type1.isAssignableFrom(type2)) {
                return 1;
            }
            if (type2.isAssignableFrom(type1)) {
                return -1;
            }
            return type1.getName().compareTo(type2.getName());
        }
    }
}

