/*
 * Decompiled with CFR 0.152.
 */
package com.buschmais.jqassistant.sonar.plugin.sensor;

import com.buschmais.jqassistant.core.report.schema.v1.ConceptType;
import com.buschmais.jqassistant.core.report.schema.v1.ConstraintType;
import com.buschmais.jqassistant.core.report.schema.v1.GroupType;
import com.buschmais.jqassistant.core.report.schema.v1.JqassistantReport;
import com.buschmais.jqassistant.core.report.schema.v1.ObjectFactory;
import com.buschmais.jqassistant.core.report.schema.v1.RuleType;
import com.buschmais.jqassistant.core.report.schema.v1.StatusEnumType;
import com.buschmais.jqassistant.sonar.plugin.JQAssistantConfiguration;
import com.buschmais.jqassistant.sonar.plugin.sensor.IssueConceptHandler;
import com.buschmais.jqassistant.sonar.plugin.sensor.IssueConstraintHandler;
import com.buschmais.jqassistant.sonar.plugin.sensor.JQAssistantRuleType;
import com.buschmais.jqassistant.sonar.plugin.sensor.LanguageResourceResolver;
import com.buschmais.jqassistant.sonar.plugin.sensor.RuleKeyResolver;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.component.ResourcePerspectives;
import org.sonar.api.platform.ComponentContainer;
import org.sonar.api.resources.Project;
import org.sonar.api.rule.RuleKey;

@Phase(name=Phase.Name.DEFAULT)
public class JQAssistantSensor
implements Sensor {
    private static final Logger LOGGER = LoggerFactory.getLogger(JQAssistantSensor.class);
    private static JqassistantReport theReport = null;
    private static String theReportFilePath = null;
    private final FileSystem fileSystem;
    private final JAXBContext reportContext;
    private final JQAssistantConfiguration configuration;
    private final RuleKeyResolver ruleResolver;
    private final IssueConceptHandler conceptHandler;
    private final IssueConstraintHandler constraintHandler;

    public JQAssistantSensor(JQAssistantConfiguration configuration, ResourcePerspectives perspectives, ComponentContainer componentContainerc, FileSystem moduleFileSystem) throws JAXBException {
        this.configuration = configuration;
        this.fileSystem = moduleFileSystem;
        HashMap<String, LanguageResourceResolver> languageResourceResolvers = new HashMap<String, LanguageResourceResolver>();
        for (LanguageResourceResolver resolver : componentContainerc.getComponentsByType(LanguageResourceResolver.class)) {
            languageResourceResolvers.put(resolver.getLanguage().toLowerCase(Locale.ENGLISH), resolver);
        }
        List ruleResolvers = componentContainerc.getComponentsByType(RuleKeyResolver.class);
        if (ruleResolvers.isEmpty()) {
            this.ruleResolver = null;
            LOGGER.error("{} will not work without additional plugin providing a {} implementation.", (Object)"jQAssistant", (Object)RuleKeyResolver.class.getSimpleName());
        } else if (ruleResolvers.size() > 1) {
            this.ruleResolver = null;
            LOGGER.error("Found more than one {} implementation. Uninstall one of the providing plugins ('sonarrules' or 'projectrules')", (Object)RuleKeyResolver.class.getSimpleName());
        } else {
            this.ruleResolver = (RuleKeyResolver)ruleResolvers.get(0);
        }
        this.reportContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
        this.conceptHandler = new IssueConceptHandler(perspectives, languageResourceResolvers);
        this.constraintHandler = new IssueConstraintHandler(perspectives, languageResourceResolvers);
    }

    public boolean shouldExecuteOnProject(Project project) {
        boolean disabled = this.configuration.isSensorDisabled();
        if (disabled) {
            LOGGER.info("{} is disabled on project {}", (Object)"jQAssistant", (Object)project.getName());
        } else if (this.ruleResolver == null) {
            disabled = true;
        }
        return !disabled;
    }

    public void analyse(Project project, SensorContext sensorContext) {
        File reportFile = this.findReportFile(project, "");
        if (reportFile != null) {
            LOGGER.debug("Use report found at '{}'.", (Object)reportFile.getAbsolutePath());
            JqassistantReport report = this.readReport(reportFile);
            this.evaluateReport(project, sensorContext, report);
        } else {
            LOGGER.info("No report found at {} for project {}... (do nothing).", (Object)this.determineConfiguredReportPath(), (Object)project.getName());
        }
    }

    public String toString() {
        return "jQAssistant";
    }

    private JqassistantReport readReport(File reportFile) {
        if (theReport != null && reportFile.getAbsolutePath().equals(theReportFilePath)) {
            return theReport;
        }
        try {
            Unmarshaller unmarshaller = this.reportContext.createUnmarshaller();
            theReport = (JqassistantReport)unmarshaller.unmarshal((Source)new StreamSource(reportFile), JqassistantReport.class).getValue();
            theReportFilePath = reportFile.getAbsolutePath();
            return theReport;
        }
        catch (JAXBException e) {
            throw new IllegalStateException("Cannot read jQAssistant report from file " + reportFile, e);
        }
    }

    private void evaluateReport(Project project, SensorContext sensorContext, JqassistantReport report) {
        for (GroupType groupType : report.getGroup()) {
            LOGGER.info("Processing group '{}'", (Object)groupType.getId());
            for (RuleType ruleType : groupType.getConceptOrConstraint()) {
                String id;
                if (!StatusEnumType.FAILURE.equals((Object)ruleType.getStatus())) continue;
                RuleKey ruleKey = this.ruleResolver.resolve(project, ruleType instanceof ConceptType ? JQAssistantRuleType.Concept : JQAssistantRuleType.Constraint, id = ruleType.getId());
                if (ruleKey == null) {
                    LOGGER.warn("Cannot resolve rule key for id '{}'. No issue will be created! Rule not active?", (Object)id);
                    continue;
                }
                if (ruleType instanceof ConceptType) {
                    if (this.configuration.suppressConceptFailures()) continue;
                    this.conceptHandler.process(project, sensorContext, (ConceptType)ruleType, ruleKey);
                    continue;
                }
                if (!(ruleType instanceof ConstraintType)) continue;
                this.constraintHandler.process(project, sensorContext, (ConstraintType)ruleType, ruleKey);
            }
        }
    }

    private File findReportFile(Project project, String pathPrefix) {
        if (project == null) {
            return null;
        }
        String configReportPath = this.determineConfiguredReportPath();
        File reportFile = this.fileSystem.resolvePath(pathPrefix + configReportPath);
        if (reportFile.exists()) {
            return reportFile;
        }
        if (project.isModule()) {
            return this.findReportFile(project.getParent(), pathPrefix + "../");
        }
        return null;
    }

    private String determineConfiguredReportPath() {
        String configReportPath = this.configuration.getReportPath();
        if (configReportPath == null || configReportPath.isEmpty()) {
            configReportPath = "target/jqassistant/jqassistant-report.xml";
        }
        return configReportPath;
    }
}

